#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger
version:              1.42.1
visibility:           public
id:                   hledger-1.42.1-JZ0076ZRbzLDSgxX4QlgRJ
key:                  hledger-1.42.1-JZ0076ZRbzLDSgxX4QlgRJ
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Command-line interface for the hledger accounting system
description:
    The command-line interface for the hledger accounting system.
    Its basic function is to read a plain text file describing
    financial transactions and produce useful reports.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance, Console
abi:                  4590fdc4378aeb40dde7b8cde8fb8155
exposed:              True
exposed-modules:
    Hledger.Cli Hledger.Cli.Anchor Hledger.Cli.Anon
    Hledger.Cli.CliOptions Hledger.Cli.Commands
    Hledger.Cli.Commands.Accounts Hledger.Cli.Commands.Activity
    Hledger.Cli.Commands.Add Hledger.Cli.Commands.Aregister
    Hledger.Cli.Commands.Balance Hledger.Cli.Commands.Balancesheet
    Hledger.Cli.Commands.Balancesheetequity
    Hledger.Cli.Commands.Cashflow Hledger.Cli.Commands.Check
    Hledger.Cli.Commands.Close Hledger.Cli.Commands.Codes
    Hledger.Cli.Commands.Commodities Hledger.Cli.Commands.Demo
    Hledger.Cli.Commands.Descriptions Hledger.Cli.Commands.Diff
    Hledger.Cli.Commands.Files Hledger.Cli.Commands.Help
    Hledger.Cli.Commands.Import Hledger.Cli.Commands.Incomestatement
    Hledger.Cli.Commands.Notes Hledger.Cli.Commands.Payees
    Hledger.Cli.Commands.Prices Hledger.Cli.Commands.Print
    Hledger.Cli.Commands.Register Hledger.Cli.Commands.Rewrite
    Hledger.Cli.Commands.Roi Hledger.Cli.Commands.Run
    Hledger.Cli.Commands.Stats Hledger.Cli.Commands.Tags
    Hledger.Cli.CompoundBalanceCommand Hledger.Cli.Conf
    Hledger.Cli.DocFiles Hledger.Cli.Script Hledger.Cli.Utils
    Hledger.Cli.Version

hidden-modules:       Paths_hledger
import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-1.42.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-1.42.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-1.42.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger
hs-libraries:         HShledger-1.42.1-JZ0076ZRbzLDSgxX4QlgRJ
depends:
    Decimal-0.5.2-LMKo4ChlKtKGTJQoPteyo1
    Diff-0.5-BWrCyH5C3Bv4s0avY6wwOE
    aeson-2.1.2.1-7VTFzNaeQhH4xougawMBap
    ansi-terminal-1.0.2-JNQYc01xThWEgUAi55dqd4 base-4.17.2.1
    bytestring-0.11.5.3 cmdargs-0.10.22-KMcxPO0UszDDPT8hI73uO5
    containers-0.6.7 data-default-0.7.1.3-3HSSfTTpRalIdOguxliHyd
    directory-1.3.7.1 extra-1.7.16-1cKp5Cy9JHKKmY0j3a7DvM
    filepath-1.4.2.2 githash-0.1.6.3-36Aq78FnI4hBRzdivp7CVL
    hashable-1.4.6.0-8MG0S5dfyXU6lRGLMgbs1l haskeline-0.8.2
    hledger-lib-1.42.1-E4d6tfZGLXLJ6Fc2tqvo6I
    lucid-2.11.20250303-85dma79ei7Z9DLY1D1vfol
    math-functions-0.3.4.4-GSc0YExdLbG4xzibohJAUs
    megaparsec-9.7.0-EiOytuystFBC1v5RoiaLHB
    microlens-0.4.14.0-71jOCsiFFF8LaovsPy6HDt
    modern-uri-0.3.6.1-C73ibVMp9uG7YAHgvQozke mtl-2.2.2
    process-1.6.18.0 regex-tdfa-1.3.2.4-Fuwr2ihnaho7XtY5yWf5G3
    safe-0.3.21-EvJ6Ca7ZgFx49PYHKYQDLu
    shakespeare-2.1.4-Dz2Hsyah49KEifXrVULqaL
    split-0.2.5-Dujwwofvw7aEFmjRmWhj9Q
    tabular-0.2.2.8-GPlaI3PukxDKI4c6j3m1vm
    tasty-1.5.2-8MWT7CdCODFHs3Dq0tvOIE
    temporary-1.3-2TqpxYLmc2a7SnjGVjAMFZ text-2.0.2
    text-ansi-0.3.0.1-I9GwyqPMgH1LmHNz6r7fu0 time-1.12.2
    timeit-2.0-GSLifhpRLI5Gr54jWRx5t0 transformers-0.5.6.2
    unordered-containers-0.2.20-Iia3zhz8DVL3Efh3E6ja96
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm
    utility-ht-0.0.17.2-36NnWO9trr01Pf2ykjlwEH
    wizards-1.0.3-KdOLRFMRRl1t6euiwGd

haddock-interfaces:   /usr/share/doc/hledger/html/hledger.haddock
haddock-html:         /usr/share/doc/hledger/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

