#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger
version:              1.42
visibility:           public
id:                   hledger-1.42-B7O59N04gDM85mLUB7AuCu
key:                  hledger-1.42-B7O59N04gDM85mLUB7AuCu
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Command-line interface for the hledger accounting system
description:
    The command-line interface for the hledger accounting system.
    Its basic function is to read a plain text file describing
    financial transactions and produce useful reports.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance, Console
abi:                  41fde601e061ed002565beb7db0bfb56
exposed:              True
exposed-modules:
    Hledger.Cli Hledger.Cli.Anchor Hledger.Cli.Anon
    Hledger.Cli.CliOptions Hledger.Cli.Commands
    Hledger.Cli.Commands.Accounts Hledger.Cli.Commands.Activity
    Hledger.Cli.Commands.Add Hledger.Cli.Commands.Aregister
    Hledger.Cli.Commands.Balance Hledger.Cli.Commands.Balancesheet
    Hledger.Cli.Commands.Balancesheetequity
    Hledger.Cli.Commands.Cashflow Hledger.Cli.Commands.Check
    Hledger.Cli.Commands.Close Hledger.Cli.Commands.Codes
    Hledger.Cli.Commands.Commodities Hledger.Cli.Commands.Demo
    Hledger.Cli.Commands.Descriptions Hledger.Cli.Commands.Diff
    Hledger.Cli.Commands.Files Hledger.Cli.Commands.Help
    Hledger.Cli.Commands.Import Hledger.Cli.Commands.Incomestatement
    Hledger.Cli.Commands.Notes Hledger.Cli.Commands.Payees
    Hledger.Cli.Commands.Prices Hledger.Cli.Commands.Print
    Hledger.Cli.Commands.Register Hledger.Cli.Commands.Rewrite
    Hledger.Cli.Commands.Roi Hledger.Cli.Commands.Run
    Hledger.Cli.Commands.Stats Hledger.Cli.Commands.Tags
    Hledger.Cli.CompoundBalanceCommand Hledger.Cli.Conf
    Hledger.Cli.DocFiles Hledger.Cli.Script Hledger.Cli.Utils
    Hledger.Cli.Version

hidden-modules:       Paths_hledger
import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-1.42
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-1.42
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-1.42
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger
hs-libraries:         HShledger-1.42-B7O59N04gDM85mLUB7AuCu
depends:
    Decimal-0.5.2-ve1gQUeDi720IdCvxcZwJ Diff-0.5-GnHNOzcARrV6MSGDbAte3o
    aeson-2.1.2.1-IUt8ms8F4mK1p5ihNOaPfT
    ansi-terminal-1.0.2-5rU4pkSh0boE3ReNmRQ6hH base-4.17.2.1
    bytestring-0.11.5.3 cmdargs-0.10.22-KMcxPO0UszDDPT8hI73uO5
    containers-0.6.7 data-default-0.7.1.3-3HSSfTTpRalIdOguxliHyd
    directory-1.3.7.1 extra-1.7.16-2947RCqGIqYFOyB1jx0D04
    filepath-1.4.2.2 githash-0.1.6.3-B0dUCoK53b5JeMVhe3ZZZz
    hashable-1.4.6.0-2vEivDIcaMF9mfkC7wRjoU haskeline-0.8.2
    hledger-lib-1.42-Dautn2bHbli9iH9snLuvU0
    lucid-2.11.20250303-AZEJMHfesrA1piBhMzmzgy
    math-functions-0.3.4.4-LCTV0ERVJdZ23NmhXeVXrX
    megaparsec-9.7.0-JCsirEhLFw2GjFGhRNZw9x
    microlens-0.4.14.0-71jOCsiFFF8LaovsPy6HDt
    modern-uri-0.3.6.1-CTJ90JTK8rw8IyGoe7rhYM mtl-2.2.2
    process-1.6.18.0 regex-tdfa-1.3.2.4-HNpewnjjvU3IRU9BMm5w9q
    safe-0.3.21-JSgKJ1qQ11UGSifs2bSHTA
    shakespeare-2.1.4-2RnPuW09BnpI5HoZKWSnah
    split-0.2.5-Dujwwofvw7aEFmjRmWhj9Q
    tabular-0.2.2.8-GPlaI3PukxDKI4c6j3m1vm
    tasty-1.5-KfqPODqIxWIB9zLnFruxu2
    temporary-1.3-sx8gB5yETjAWMh3lNT3tk text-2.0.2
    text-ansi-0.3.0.1-Bb5D7QjV0303PtlSCxbwyL time-1.12.2
    timeit-2.0-GSLifhpRLI5Gr54jWRx5t0 transformers-0.5.6.2
    unordered-containers-0.2.20-8z8yrOH3Dwd8Gc78vZRE2k
    utf8-string-1.0.2-6nfZpgw1Ffy3MDnMPT0XX9
    utility-ht-0.0.17.2-Ksgu7tvLAUS5uh1shKeHtD
    wizards-1.0.3-KdOLRFMRRl1t6euiwGd

haddock-interfaces:   /usr/share/doc/hledger/html/hledger.haddock
haddock-html:         /usr/share/doc/hledger/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

