#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger
version:              1.41
visibility:           public
id:                   hledger-1.41-BWC1CEcIisXIVbvW2A0ich
key:                  hledger-1.41-BWC1CEcIisXIVbvW2A0ich
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Command-line interface for the hledger accounting system
description:
    The command-line interface for the hledger accounting system.
    Its basic function is to read a plain text file describing
    financial transactions and produce useful reports.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance, Console
abi:                  a5f5939f2782c6bce35f9a49ada5aa33
exposed:              True
exposed-modules:
    Hledger.Cli Hledger.Cli.Anchor Hledger.Cli.Anon
    Hledger.Cli.CliOptions Hledger.Cli.Commands
    Hledger.Cli.Commands.Accounts Hledger.Cli.Commands.Activity
    Hledger.Cli.Commands.Add Hledger.Cli.Commands.Aregister
    Hledger.Cli.Commands.Balance Hledger.Cli.Commands.Balancesheet
    Hledger.Cli.Commands.Balancesheetequity
    Hledger.Cli.Commands.Cashflow Hledger.Cli.Commands.Check
    Hledger.Cli.Commands.Close Hledger.Cli.Commands.Codes
    Hledger.Cli.Commands.Commodities Hledger.Cli.Commands.Demo
    Hledger.Cli.Commands.Descriptions Hledger.Cli.Commands.Diff
    Hledger.Cli.Commands.Files Hledger.Cli.Commands.Help
    Hledger.Cli.Commands.Import Hledger.Cli.Commands.Incomestatement
    Hledger.Cli.Commands.Notes Hledger.Cli.Commands.Payees
    Hledger.Cli.Commands.Prices Hledger.Cli.Commands.Print
    Hledger.Cli.Commands.Register Hledger.Cli.Commands.Rewrite
    Hledger.Cli.Commands.Roi Hledger.Cli.Commands.Stats
    Hledger.Cli.Commands.Tags Hledger.Cli.CompoundBalanceCommand
    Hledger.Cli.Conf Hledger.Cli.DocFiles Hledger.Cli.Script
    Hledger.Cli.Utils Hledger.Cli.Version

hidden-modules:       Paths_hledger
import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-1.41
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-1.41
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-1.41
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger
hs-libraries:         HShledger-1.41-BWC1CEcIisXIVbvW2A0ich
depends:
    Decimal-0.5.2-IWeaesuqq6gGvo8Ig64LdE
    Diff-0.5-DfgrTjzmKsXIKxa4pCXDt2
    aeson-2.1.2.1-4RB85zdNr5p3whZ1np3a31
    ansi-terminal-1.0.2-4v7foyTOWos7vsV6BCUMgI base-4.17.2.1
    bytestring-0.11.5.3 cmdargs-0.10.22-KMcxPO0UszDDPT8hI73uO5
    containers-0.6.7 data-default-0.7.1.3-3HSSfTTpRalIdOguxliHyd
    directory-1.3.7.1 extra-1.7.16-KGJm7HE8TMo8c4jTE4Z3yy
    filepath-1.4.2.2 githash-0.1.6.3-7Zddx0w8sxlBZCCQmjKySz
    hashable-1.4.5.0-EMf4Iv4OllUGRj72K4SCf0 haskeline-0.8.2
    hledger-lib-1.41-FrwV87zNqMYHm58d5Ibptv
    lucid-2.11.20250303-8NfgzU3FZa9LDl4fGbByDe
    math-functions-0.3.4.4-507XfRlKPRrKX3yxyWOUUs
    megaparsec-9.7.0-820EiikhmYYJfbjX1fu2Y5
    microlens-0.4.14.0-71jOCsiFFF8LaovsPy6HDt
    modern-uri-0.3.6.1-Df4NIcn1VRl4LxiszBIf3i mtl-2.2.2
    process-1.6.18.0 regex-tdfa-1.3.2.4-8SMpKQokk9j1XbuNe0lCm6
    safe-0.3.21-DKOKWo9pals8WHvcv2YlI8
    shakespeare-2.1.4-6W994xTQ8VLK5GedtaogvE
    split-0.2.5-Dujwwofvw7aEFmjRmWhj9Q
    tabular-0.2.2.8-GPlaI3PukxDKI4c6j3m1vm
    tasty-1.5-J1ZQyr0k0jJBCfcybwZuhZ
    temporary-1.3-DvBGl4XgxXUEV6N6poxsKk terminfo-0.4.1.5 text-2.0.2
    text-ansi-0.3.0.1-4fSTlDlmcDBEv8Lxk3DY7G time-1.12.2
    timeit-2.0-GSLifhpRLI5Gr54jWRx5t0 transformers-0.5.6.2
    unordered-containers-0.2.20-L410VxfvorQ5RMb8wocThG
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm
    utility-ht-0.0.17.2-J5e66nSZUyPIabC0TVrOqb
    wizards-1.0.3-KdOLRFMRRl1t6euiwGd

haddock-interfaces:   /usr/share/doc/hledger/html/hledger.haddock
haddock-html:         /usr/share/doc/hledger/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

