#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger
version:              1.41
visibility:           public
id:                   hledger-1.41-BFt6dS6oKujJa0BbgzBEeU
key:                  hledger-1.41-BFt6dS6oKujJa0BbgzBEeU
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Command-line interface for the hledger accounting system
description:
    The command-line interface for the hledger accounting system.
    Its basic function is to read a plain text file describing
    financial transactions and produce useful reports.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance, Console
abi:                  ca244613ab4c94a9d343142436a93bef
exposed:              True
exposed-modules:
    Hledger.Cli Hledger.Cli.Anchor Hledger.Cli.Anon
    Hledger.Cli.CliOptions Hledger.Cli.Commands
    Hledger.Cli.Commands.Accounts Hledger.Cli.Commands.Activity
    Hledger.Cli.Commands.Add Hledger.Cli.Commands.Aregister
    Hledger.Cli.Commands.Balance Hledger.Cli.Commands.Balancesheet
    Hledger.Cli.Commands.Balancesheetequity
    Hledger.Cli.Commands.Cashflow Hledger.Cli.Commands.Check
    Hledger.Cli.Commands.Close Hledger.Cli.Commands.Codes
    Hledger.Cli.Commands.Commodities Hledger.Cli.Commands.Demo
    Hledger.Cli.Commands.Descriptions Hledger.Cli.Commands.Diff
    Hledger.Cli.Commands.Files Hledger.Cli.Commands.Help
    Hledger.Cli.Commands.Import Hledger.Cli.Commands.Incomestatement
    Hledger.Cli.Commands.Notes Hledger.Cli.Commands.Payees
    Hledger.Cli.Commands.Prices Hledger.Cli.Commands.Print
    Hledger.Cli.Commands.Register Hledger.Cli.Commands.Rewrite
    Hledger.Cli.Commands.Roi Hledger.Cli.Commands.Stats
    Hledger.Cli.Commands.Tags Hledger.Cli.CompoundBalanceCommand
    Hledger.Cli.Conf Hledger.Cli.DocFiles Hledger.Cli.Script
    Hledger.Cli.Utils Hledger.Cli.Version

hidden-modules:       Paths_hledger
import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-1.41
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-1.41
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-1.41
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger
hs-libraries:         HShledger-1.41-BFt6dS6oKujJa0BbgzBEeU
depends:
    Decimal-0.5.2-9MFIBXeyIJJLdqol8CveNZ
    Diff-0.5-2WBqMHHuMKKJPXXpUwfTmb
    aeson-2.1.2.1-IZ8jLcnEISD7S5Vyf2Tehm
    ansi-terminal-1.0.2-FTkVGNDxEfy5jKOkYDwQmU base-4.17.2.1
    bytestring-0.11.5.3 cmdargs-0.10.22-KMcxPO0UszDDPT8hI73uO5
    containers-0.6.7 data-default-0.7.1.2-2qohbnSvS9oK93FFGOJ5gM
    directory-1.3.7.1 extra-1.7.16-84Gt3POgtfP5cuz093nHzi
    filepath-1.4.2.2 githash-0.1.6.3-1M1Z10SoNv274JsnwQKUT3
    hashable-1.4.5.0-FhpNKvHQsJeLXuGJFx8piW haskeline-0.8.2
    hledger-lib-1.41-BFYfKJYlOCLEyOkfP0kzFH
    lucid-2.11.20250303-LD7vyPATxZWJCLw60QjZxd
    math-functions-0.3.4.4-9j9uYqvjGab1srsM59hmRH
    megaparsec-9.7.0-EujlCtvd6hmm53pqN4SFa
    microlens-0.4.14.0-71jOCsiFFF8LaovsPy6HDt
    modern-uri-0.3.6.1-81WWwj6HwtaI6Dz55R531W mtl-2.2.2
    process-1.6.18.0 regex-tdfa-1.3.2.4-4BRmOkLS3ql2wqEC5AAoF9
    safe-0.3.21-KEfOvx15i1f7ewOxq0ZYoN
    shakespeare-2.1.4-CqqdfXGNZiD7D7HpP7arnf
    split-0.2.5-Dujwwofvw7aEFmjRmWhj9Q
    tabular-0.2.2.8-GPlaI3PukxDKI4c6j3m1vm
    tasty-1.5-2drm3vbeJH2JfJ6SzRblHQ
    temporary-1.3-Hp6jkQ9rtgX3Zx1BXXhTu3 terminfo-0.4.1.5 text-2.0.2
    text-ansi-0.3.0.1-CcSxFDB4JlVAcQgZPc8VCR time-1.12.2
    timeit-2.0-GSLifhpRLI5Gr54jWRx5t0 transformers-0.5.6.2
    unordered-containers-0.2.20-79maJZZuZDu8bRI1CHuoJG
    utf8-string-1.0.2-EpYvbnx7dwVHTduFVbgaKq
    utility-ht-0.0.17.2-ITHafRbMeZc47m02ttO0g9
    wizards-1.0.3-KdOLRFMRRl1t6euiwGd

haddock-interfaces:   /usr/share/doc/hledger/html/hledger.haddock
haddock-html:         /usr/share/doc/hledger/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

