#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger
version:              1.40
visibility:           public
id:                   hledger-1.40-CpEJnqG0hK84f3NNJM35gf
key:                  hledger-1.40-CpEJnqG0hK84f3NNJM35gf
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Command-line interface for the hledger accounting system
description:
    The command-line interface for the hledger accounting system.
    Its basic function is to read a plain text file describing
    financial transactions and produce useful reports.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance, Console
abi:                  a1a9cb9b4fd76bdf775cd207e2d4ded9
exposed:              True
exposed-modules:
    Hledger.Cli Hledger.Cli.Anon Hledger.Cli.CliOptions
    Hledger.Cli.Commands Hledger.Cli.Commands.Accounts
    Hledger.Cli.Commands.Activity Hledger.Cli.Commands.Add
    Hledger.Cli.Commands.Aregister Hledger.Cli.Commands.Balance
    Hledger.Cli.Commands.Balancesheet
    Hledger.Cli.Commands.Balancesheetequity
    Hledger.Cli.Commands.Cashflow Hledger.Cli.Commands.Check
    Hledger.Cli.Commands.Close Hledger.Cli.Commands.Codes
    Hledger.Cli.Commands.Commodities Hledger.Cli.Commands.Demo
    Hledger.Cli.Commands.Descriptions Hledger.Cli.Commands.Diff
    Hledger.Cli.Commands.Files Hledger.Cli.Commands.Help
    Hledger.Cli.Commands.Import Hledger.Cli.Commands.Incomestatement
    Hledger.Cli.Commands.Notes Hledger.Cli.Commands.Payees
    Hledger.Cli.Commands.Prices Hledger.Cli.Commands.Print
    Hledger.Cli.Commands.Register Hledger.Cli.Commands.Rewrite
    Hledger.Cli.Commands.Roi Hledger.Cli.Commands.Stats
    Hledger.Cli.Commands.Tags Hledger.Cli.CompoundBalanceCommand
    Hledger.Cli.Conf Hledger.Cli.DocFiles Hledger.Cli.Script
    Hledger.Cli.Utils Hledger.Cli.Version

hidden-modules:       Paths_hledger
import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-1.40
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-1.40
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-1.40
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger
hs-libraries:         HShledger-1.40-CpEJnqG0hK84f3NNJM35gf
depends:
    Decimal-0.5.2-5cj0SAP9Brc4OvqOhAwss9
    Diff-0.4.1-BCWGZ4JsbfNAEOmzFgneWv
    aeson-2.1.2.1-9HQxGJjc2cdAmcsURaBDXL
    ansi-terminal-1.0.2-7CE1Q1IrIunJWV5ocxl3bT base-4.17.2.1
    bytestring-0.11.5.3 cmdargs-0.10.22-KMcxPO0UszDDPT8hI73uO5
    containers-0.6.7 data-default-0.7.1.2-7c115eFpvxq7Z5z0er1qPt
    directory-1.3.7.1 extra-1.7.16-CR3YhfuUieu5v43yLxm9nT
    filepath-1.4.2.2 githash-0.1.6.3-80ZTPIrG0Z8DGp8XhCyujF
    hashable-1.4.4.0-Bi9h4Si3Ui62sqHmMmGfiv haskeline-0.8.2
    hledger-lib-1.40-3ADN0LpDKO7FRnswZusbvR
    lucid-2.11.20230408-JEaiKD20n20C1EZEpxqFYz
    math-functions-0.3.4.4-AsePCd8ysivBFmCvFu7X7
    megaparsec-9.7.0-InMnv3t1CSe1tTlGcmutcd
    microlens-0.4.14.0-71jOCsiFFF8LaovsPy6HDt mtl-2.2.2
    process-1.6.18.0 regex-tdfa-1.3.2.4-5VzyiYRIxzjC7QH7QCwrYL
    safe-0.3.21-Llz318DC7aPJTnXvnv5jp2
    shakespeare-2.1.3-KwNVwb8ZIYQ3FbPrmRTne0
    split-0.2.5-JwWMTmXvu7fChkavPTERve
    tabular-0.2.2.8-GPlaI3PukxDKI4c6j3m1vm
    tasty-1.5-Ezyjsj4s9uQ4MIGkkKZoRH
    temporary-1.3-E8f1uOIpWdRBhteVTrQZoF terminfo-0.4.1.5 text-2.0.2
    text-ansi-0.3.0.1-4q8TW6fFCSsFofXTyxWwah time-1.12.2
    timeit-2.0-GSLifhpRLI5Gr54jWRx5t0 transformers-0.5.6.2
    unordered-containers-0.2.20-3czZ5Len2GTFaAkRxFZe7E
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm
    utility-ht-0.0.17.2-7k5c6jxQIvw6VLsFjF3p7F
    wizards-1.0.3-KdOLRFMRRl1t6euiwGd

haddock-interfaces:   /usr/share/doc/hledger/html/hledger.haddock
haddock-html:         /usr/share/doc/hledger/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

