#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger
version:              1.40
visibility:           public
id:                   hledger-1.40-8wEPlhw93eeAsMVmTBUO4L
key:                  hledger-1.40-8wEPlhw93eeAsMVmTBUO4L
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Command-line interface for the hledger accounting system
description:
    The command-line interface for the hledger accounting system.
    Its basic function is to read a plain text file describing
    financial transactions and produce useful reports.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance, Console
abi:                  95d9c9090201fcb5e101bbfc2656dfc1
exposed:              True
exposed-modules:
    Hledger.Cli Hledger.Cli.Anon Hledger.Cli.CliOptions
    Hledger.Cli.Commands Hledger.Cli.Commands.Accounts
    Hledger.Cli.Commands.Activity Hledger.Cli.Commands.Add
    Hledger.Cli.Commands.Aregister Hledger.Cli.Commands.Balance
    Hledger.Cli.Commands.Balancesheet
    Hledger.Cli.Commands.Balancesheetequity
    Hledger.Cli.Commands.Cashflow Hledger.Cli.Commands.Check
    Hledger.Cli.Commands.Close Hledger.Cli.Commands.Codes
    Hledger.Cli.Commands.Commodities Hledger.Cli.Commands.Demo
    Hledger.Cli.Commands.Descriptions Hledger.Cli.Commands.Diff
    Hledger.Cli.Commands.Files Hledger.Cli.Commands.Help
    Hledger.Cli.Commands.Import Hledger.Cli.Commands.Incomestatement
    Hledger.Cli.Commands.Notes Hledger.Cli.Commands.Payees
    Hledger.Cli.Commands.Prices Hledger.Cli.Commands.Print
    Hledger.Cli.Commands.Register Hledger.Cli.Commands.Rewrite
    Hledger.Cli.Commands.Roi Hledger.Cli.Commands.Stats
    Hledger.Cli.Commands.Tags Hledger.Cli.CompoundBalanceCommand
    Hledger.Cli.Conf Hledger.Cli.DocFiles Hledger.Cli.Script
    Hledger.Cli.Utils Hledger.Cli.Version

hidden-modules:       Paths_hledger
import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-1.40
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-1.40
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-1.40
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger
hs-libraries:         HShledger-1.40-8wEPlhw93eeAsMVmTBUO4L
depends:
    Decimal-0.5.2-3GgHvvTS1LYHyLdCFa3RYc
    Diff-0.4.1-6F2RzRAF4vMBbZwUZsGcD0
    aeson-2.1.2.1-KxhFBZPQYXiG3TO3nhA4Kq
    ansi-terminal-1.0.2-FdTURvxQW9QL5jnf7uGcXG base-4.17.2.1
    bytestring-0.11.5.3 cmdargs-0.10.22-KMcxPO0UszDDPT8hI73uO5
    containers-0.6.7 data-default-0.7.1.2-8yRIq8kwMNHG7OFJsT5Ayy
    directory-1.3.7.1 extra-1.7.16-4SvI72pYgfdBRotMZ3tf9z
    filepath-1.4.2.2 githash-0.1.6.3-1ssF2k1ghtsIF5ldbExMyD
    hashable-1.4.4.0-E3AlBtIk95ULiiCgr6U6fg haskeline-0.8.2
    hledger-lib-1.40-BTIRdD8PFsh5cRdRdHgKij
    lucid-2.11.20250303-FzpbIfKX1poApRbfKsHV0r
    math-functions-0.3.4.4-D6S987v1z39noXERkd0eP
    megaparsec-9.7.0-Hsn4IAkVRB2A2QgsJUzrvG
    microlens-0.4.14.0-71jOCsiFFF8LaovsPy6HDt mtl-2.2.2
    process-1.6.18.0 regex-tdfa-1.3.2.4-En3QX8Ja5Gq8UtJhpcCkzY
    safe-0.3.21-KJlW7jRgZb73RD220AjTnZ
    shakespeare-2.1.4-KlVyuQQZS2TKdozCHBI993
    split-0.2.5-HF22Q1cIKmoK4fHDRbSUwV
    tabular-0.2.2.8-GPlaI3PukxDKI4c6j3m1vm
    tasty-1.5-1LVG3MTEaeV50BoWi4FIMR
    temporary-1.3-G3JGTlFyfueEWhF9il8L2k terminfo-0.4.1.5 text-2.0.2
    text-ansi-0.3.0.1-X4fG6wQIdSFvF0r9bkJf3 time-1.12.2
    timeit-2.0-GSLifhpRLI5Gr54jWRx5t0 transformers-0.5.6.2
    unordered-containers-0.2.20-Ee1qJYwM3Cx9FXWFU8Ujy3
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm
    utility-ht-0.0.17.2-56PHatT6sF7EharfQK9NK2
    wizards-1.0.3-KdOLRFMRRl1t6euiwGd

haddock-interfaces:   /usr/share/doc/hledger/html/hledger.haddock
haddock-html:         /usr/share/doc/hledger/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

