#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger
version:              1.40
visibility:           public
id:                   hledger-1.40-56uQPs5vfNKJzynUHsNn1e
key:                  hledger-1.40-56uQPs5vfNKJzynUHsNn1e
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Command-line interface for the hledger accounting system
description:
    The command-line interface for the hledger accounting system.
    Its basic function is to read a plain text file describing
    financial transactions and produce useful reports.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance, Console
abi:                  49065d88e0c3c0eefab53072b0e57497
exposed:              True
exposed-modules:
    Hledger.Cli Hledger.Cli.Anon Hledger.Cli.CliOptions
    Hledger.Cli.Commands Hledger.Cli.Commands.Accounts
    Hledger.Cli.Commands.Activity Hledger.Cli.Commands.Add
    Hledger.Cli.Commands.Aregister Hledger.Cli.Commands.Balance
    Hledger.Cli.Commands.Balancesheet
    Hledger.Cli.Commands.Balancesheetequity
    Hledger.Cli.Commands.Cashflow Hledger.Cli.Commands.Check
    Hledger.Cli.Commands.Close Hledger.Cli.Commands.Codes
    Hledger.Cli.Commands.Commodities Hledger.Cli.Commands.Demo
    Hledger.Cli.Commands.Descriptions Hledger.Cli.Commands.Diff
    Hledger.Cli.Commands.Files Hledger.Cli.Commands.Help
    Hledger.Cli.Commands.Import Hledger.Cli.Commands.Incomestatement
    Hledger.Cli.Commands.Notes Hledger.Cli.Commands.Payees
    Hledger.Cli.Commands.Prices Hledger.Cli.Commands.Print
    Hledger.Cli.Commands.Register Hledger.Cli.Commands.Rewrite
    Hledger.Cli.Commands.Roi Hledger.Cli.Commands.Stats
    Hledger.Cli.Commands.Tags Hledger.Cli.CompoundBalanceCommand
    Hledger.Cli.Conf Hledger.Cli.DocFiles Hledger.Cli.Script
    Hledger.Cli.Utils Hledger.Cli.Version

hidden-modules:       Paths_hledger
import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-1.40
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-1.40
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-1.40
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger
hs-libraries:         HShledger-1.40-56uQPs5vfNKJzynUHsNn1e
depends:
    Decimal-0.5.2-AZ1DirwOuA1Dolz0PpJdzZ
    Diff-0.4.1-KLr9PfX1xcQ7rTrhHR462U
    aeson-2.1.2.1-6q2KNYwRaL29rPm6MMaiUC
    ansi-terminal-1.0.2-IimOqSN1qRUFeipP6ofJQ base-4.17.2.1
    bytestring-0.11.5.3 cmdargs-0.10.22-KMcxPO0UszDDPT8hI73uO5
    containers-0.6.7 data-default-0.7.1.2-8yRIq8kwMNHG7OFJsT5Ayy
    directory-1.3.7.1 extra-1.7.16-3MpJB5o0ESB1pjz4ZT9XVu
    filepath-1.4.2.2 githash-0.1.6.3-9Ub3iO8mezZEDyqnsfb7Ym
    hashable-1.4.4.0-AmJtI56ndXc1GvGfBNNgwb haskeline-0.8.2
    hledger-lib-1.40-3E87q1E5b6L3h9rmVefd1H
    lucid-2.11.20250303-BBosqcnaqALopA4iulTCL
    math-functions-0.3.4.4-FVa3z0DxqghFhUkin99UZQ
    megaparsec-9.7.0-9KX7uZoGWhIHAGHTH7OWSU
    microlens-0.4.14.0-71jOCsiFFF8LaovsPy6HDt mtl-2.2.2
    process-1.6.18.0 regex-tdfa-1.3.2.4-DzgOWHlgf3T5HZBC9uVz6f
    safe-0.3.21-85eF7qPff6wBGTusoDGORM
    shakespeare-2.1.3-LfEVIncrchJ2i1LBCpCzBy
    split-0.2.5-HF22Q1cIKmoK4fHDRbSUwV
    tabular-0.2.2.8-GPlaI3PukxDKI4c6j3m1vm
    tasty-1.5-Cig7BoCvuBI5IwHg7ZMnX
    temporary-1.3-836zY2cPz8HAaBXH2WMEd1 terminfo-0.4.1.5 text-2.0.2
    text-ansi-0.3.0.1-KZAaSPTyJXj2hmqfon1Qvh time-1.12.2
    timeit-2.0-GSLifhpRLI5Gr54jWRx5t0 transformers-0.5.6.2
    unordered-containers-0.2.20-3NcLl7S6t7kAuh7l4Ieeoo
    utf8-string-1.0.2-FAQSGuIUGqDKZx6mH04y15
    utility-ht-0.0.17.2-9H14UMJr8p5KIpk0YSK5q6
    wizards-1.0.3-KdOLRFMRRl1t6euiwGd

haddock-interfaces:   /usr/share/doc/hledger/html/hledger.haddock
haddock-html:         /usr/share/doc/hledger/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

