#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger
version:              1.34
visibility:           public
id:                   hledger-1.34-FnSePWs3jReAy2JavGtukr
key:                  hledger-1.34-FnSePWs3jReAy2JavGtukr
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Command-line interface for the hledger accounting system
description:
    The command-line interface for the hledger accounting system.
    Its basic function is to read a plain text file describing
    financial transactions and produce useful reports.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance, Console
abi:                  cd77cbc45be86cc25ad5c6f3099a3d81
exposed:              True
exposed-modules:
    Hledger.Cli Hledger.Cli.Anon Hledger.Cli.CliOptions
    Hledger.Cli.Commands Hledger.Cli.Commands.Accounts
    Hledger.Cli.Commands.Activity Hledger.Cli.Commands.Add
    Hledger.Cli.Commands.Aregister Hledger.Cli.Commands.Balance
    Hledger.Cli.Commands.Balancesheet
    Hledger.Cli.Commands.Balancesheetequity
    Hledger.Cli.Commands.Cashflow Hledger.Cli.Commands.Check
    Hledger.Cli.Commands.Close Hledger.Cli.Commands.Codes
    Hledger.Cli.Commands.Commodities Hledger.Cli.Commands.Demo
    Hledger.Cli.Commands.Descriptions Hledger.Cli.Commands.Diff
    Hledger.Cli.Commands.Files Hledger.Cli.Commands.Help
    Hledger.Cli.Commands.Import Hledger.Cli.Commands.Incomestatement
    Hledger.Cli.Commands.Notes Hledger.Cli.Commands.Payees
    Hledger.Cli.Commands.Prices Hledger.Cli.Commands.Print
    Hledger.Cli.Commands.Register Hledger.Cli.Commands.Rewrite
    Hledger.Cli.Commands.Roi Hledger.Cli.Commands.Stats
    Hledger.Cli.Commands.Tags Hledger.Cli.CompoundBalanceCommand
    Hledger.Cli.DocFiles Hledger.Cli.Script Hledger.Cli.Utils
    Hledger.Cli.Version

hidden-modules:       Paths_hledger
import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-1.34
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-1.34
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-1.34
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger
hs-libraries:         HShledger-1.34-FnSePWs3jReAy2JavGtukr
depends:
    Decimal-0.5.2-BNb9YCHVG2C60ze0TOBA5o
    Diff-0.4.1-7Fwvr1SqYTt4uBZ7hvolZA
    aeson-2.1.2.1-8gRdOgbBkF57DAEniCzHis
    ansi-terminal-1.0.2-BmYwE3CMMeiHUDLKLgejP7 base-4.17.2.1
    bytestring-0.11.5.3 cmdargs-0.10.22-KMcxPO0UszDDPT8hI73uO5
    containers-0.6.7 data-default-0.7.1.2-8zpNuXeugnsCXhsU9L7wsy
    directory-1.3.7.1 extra-1.7.16-HFVkAG9ZjF7KRVgcoT9Nb3
    filepath-1.4.2.2 githash-0.1.6.3-11jnrk28U0G11QUnE5ZUS
    hashable-1.4.4.0-C1fFIG7AZLC7j0jzLm97Uw haskeline-0.8.2
    hledger-lib-1.34-KvLzBYBBYdjGaSAffYk7SW
    lucid-2.11.20230408-9XStOCn9r58DdHooc9ig19
    math-functions-0.3.4.4-CIR77uiehhbD6aE8ZXfzfl
    megaparsec-9.6.1-EEBj4pRLerNCeJDumClMn7
    microlens-0.4.14.0-71jOCsiFFF8LaovsPy6HDt mtl-2.2.2
    process-1.6.18.0 regex-tdfa-1.3.2.4-1rXqUz52vb5BdcUf9c7mO2
    safe-0.3.21-LwDGcPt9fP72KP4K2XydmJ
    shakespeare-2.1.3-FWVgGspldg8GNvdrNLm9mN
    split-0.2.5-B9q8eJqGWtOKQzzX1ITTGf
    tabular-0.2.2.8-GPlaI3PukxDKI4c6j3m1vm
    tasty-1.5-2RjRmmUFn3C7d0B2VfkuNP
    temporary-1.3-DODaRJ5BM8m1pCh7H7okdb terminfo-0.4.1.5 text-2.0.2
    text-ansi-0.3.0.1-DYcG33LoPbvB89rDfSwT2R time-1.12.2
    timeit-2.0-GSLifhpRLI5Gr54jWRx5t0 transformers-0.5.6.2
    unordered-containers-0.2.20-obNV32ZSreHxgWRz6JrKP
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm
    utility-ht-0.0.17.2-56A1yXlmBgbDIEnz2Vgz0a
    wizards-1.0.3-KdOLRFMRRl1t6euiwGd

haddock-interfaces:   /usr/share/doc/hledger/html/hledger.haddock
haddock-html:         /usr/share/doc/hledger/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

