#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger
version:              1.34
visibility:           public
id:                   hledger-1.34-19owK1zKiZrFAKHnSbhMwd
key:                  hledger-1.34-19owK1zKiZrFAKHnSbhMwd
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Command-line interface for the hledger accounting system
description:
    The command-line interface for the hledger accounting system.
    Its basic function is to read a plain text file describing
    financial transactions and produce useful reports.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance, Console
abi:                  3e35a6cc3b0fbcfc25fb150a47d25fe3
exposed:              True
exposed-modules:
    Hledger.Cli Hledger.Cli.Anon Hledger.Cli.CliOptions
    Hledger.Cli.Commands Hledger.Cli.Commands.Accounts
    Hledger.Cli.Commands.Activity Hledger.Cli.Commands.Add
    Hledger.Cli.Commands.Aregister Hledger.Cli.Commands.Balance
    Hledger.Cli.Commands.Balancesheet
    Hledger.Cli.Commands.Balancesheetequity
    Hledger.Cli.Commands.Cashflow Hledger.Cli.Commands.Check
    Hledger.Cli.Commands.Close Hledger.Cli.Commands.Codes
    Hledger.Cli.Commands.Commodities Hledger.Cli.Commands.Demo
    Hledger.Cli.Commands.Descriptions Hledger.Cli.Commands.Diff
    Hledger.Cli.Commands.Files Hledger.Cli.Commands.Help
    Hledger.Cli.Commands.Import Hledger.Cli.Commands.Incomestatement
    Hledger.Cli.Commands.Notes Hledger.Cli.Commands.Payees
    Hledger.Cli.Commands.Prices Hledger.Cli.Commands.Print
    Hledger.Cli.Commands.Register Hledger.Cli.Commands.Rewrite
    Hledger.Cli.Commands.Roi Hledger.Cli.Commands.Stats
    Hledger.Cli.Commands.Tags Hledger.Cli.CompoundBalanceCommand
    Hledger.Cli.DocFiles Hledger.Cli.Script Hledger.Cli.Utils
    Hledger.Cli.Version

hidden-modules:       Paths_hledger
import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-1.34
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-1.34
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-1.34
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger
hs-libraries:         HShledger-1.34-19owK1zKiZrFAKHnSbhMwd
depends:
    Decimal-0.5.2-3ov4NECoNfn4MtJW6ZyWTp
    Diff-0.4.1-HEnssu43s0k5bU1IlZ6xfs
    aeson-2.1.2.1-HPwo2VO3hzcFr4fiGB5Oro
    ansi-terminal-1.0.2-HPtVnAU9d4e2sgA8soPDqO base-4.17.2.1
    bytestring-0.11.5.3 cmdargs-0.10.22-KMcxPO0UszDDPT8hI73uO5
    containers-0.6.7 data-default-0.7.1.2-7c115eFpvxq7Z5z0er1qPt
    directory-1.3.7.1 extra-1.7.16-6O0vpR35xmz4TsZbH7SN4x
    filepath-1.4.2.2 githash-0.1.6.3-c1isNu4ewp8fEXTGdHTRd
    hashable-1.4.4.0-HCL6HYi7vZb6weAXUagHtJ haskeline-0.8.2
    hledger-lib-1.34-3reSaXf5QNl85MVQ9r7kFV
    lucid-2.11.20230408-JARLKkLN1EJ2jwrJLZizp6
    math-functions-0.3.4.4-5kqM7fPwSiYH0yIoqz8456
    megaparsec-9.6.1-EACNQE4V0s4sorPNkNSJS
    microlens-0.4.14.0-71jOCsiFFF8LaovsPy6HDt mtl-2.2.2
    process-1.6.18.0 regex-tdfa-1.3.2.4-B5cBQIeZ71aKqDYYL1WMI
    safe-0.3.21-A7lw0NQn6dP12vgshNzPEt
    shakespeare-2.1.3-LPXWyq6PuWMARTXyi2Wiu8
    split-0.2.5-JeJxVdKJRKMda8iubaxqh
    tabular-0.2.2.8-GPlaI3PukxDKI4c6j3m1vm
    tasty-1.5-EJOLnl0TEk16RxPSRzbe15
    temporary-1.3-2XtnvHABNGf511WcFrV1ai terminfo-0.4.1.5 text-2.0.2
    text-ansi-0.3.0.1-GKyQ3H1AAF9KAYo9ruxGDy time-1.12.2
    timeit-2.0-GSLifhpRLI5Gr54jWRx5t0 transformers-0.5.6.2
    unordered-containers-0.2.20-FFF0GulGLFtAHq6N1Lkm0s
    utf8-string-1.0.2-LQzUWC2hIN17FDKHsw4I2c
    utility-ht-0.0.17.2-4TQEKKMblWxJX90wZacb4N
    wizards-1.0.3-KdOLRFMRRl1t6euiwGd

haddock-interfaces:   /usr/share/doc/hledger/html/hledger.haddock
haddock-html:         /usr/share/doc/hledger/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

