#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                   zlib
version:                0.7.0.0
visibility:             public
id:                     zlib-0.7.0.0-CRqYHirV4cyFsC2akuoUKz
key:                    zlib-0.7.0.0-CRqYHirV4cyFsC2akuoUKz
license:                BSD-3-Clause
copyright:              (c) 2006-2016 Duncan Coutts
maintainer:
    Duncan Coutts <duncan@community.haskell.org>, Andrew Lelechenko <andrew.lelechenko@gmail.com>, Emily Pillmore <emilypi@cohomolo.gy>, Herbert Valerio Riedel <hvr@gnu.org>

author:                 Duncan Coutts <duncan@community.haskell.org>
synopsis:               Compression and decompression in the gzip and zlib formats
description:
    This package provides a pure interface for compressing and
    decompressing streams of data represented as lazy
    '\''ByteString'\''s. It uses the
    <https://en.wikipedia.org/wiki/Zlib zlib C library>
    so it has high performance. It supports the \"zlib\",
    \"gzip\" and \"raw\" compression formats.

    It provides a convenient high level API suitable for most
    tasks and for the few cases where more control is needed it
    provides access to the full zlib feature set.

category:               Codec
abi:                    a6845ad4d52eda66d4f10e08addd152e
exposed:                True
exposed-modules:
    Codec.Compression.GZip Codec.Compression.Zlib
    Codec.Compression.Zlib.Internal Codec.Compression.Zlib.Raw

hidden-modules:
    Codec.Compression.Zlib.Stream
    Codec.Compression.Zlib.ByteStringCompat

import-dirs:            /usr/lib/ghc-9.4.8/site-local/zlib-0.7.0.0
library-dirs:           /usr/lib/ghc-9.4.8/site-local/zlib-0.7.0.0
library-dirs-static:    /usr/lib/ghc-9.4.8/site-local/zlib-0.7.0.0
dynamic-library-dirs:   /usr/lib
data-dir:               /usr/share/haskell-zlib
hs-libraries:           HSzlib-0.7.0.0-CRqYHirV4cyFsC2akuoUKz
extra-libraries:        z
extra-libraries-static: z
includes:               zlib.h hs-zlib.h
depends:                base-4.17.2.1 bytestring-0.11.5.3
haddock-interfaces:     /usr/share/doc/haskell-zlib/html/zlib.haddock
haddock-html:           /usr/share/doc/haskell-zlib/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

