#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                   zeromq4-haskell
version:                0.8.0
visibility:             public
id:                     zeromq4-haskell-0.8.0-JO0XSkzXqq0Cr7Sh96ObYF
key:                    zeromq4-haskell-0.8.0-JO0XSkzXqq0Cr7Sh96ObYF
license:                MIT
copyright:              (c) 2010 - 2015 zeromq-haskell authors
maintainer:             Toralf Wittner <tw@dtex.org>
author:                 Toralf Wittner
stability:              experimental
homepage:               https://gitlab.com/twittner/zeromq-haskell/
synopsis:               Bindings to ZeroMQ 4.x
description:
    The 0MQ lightweight messaging kernel is a library which extends
    the standard socket interfaces with features traditionally provided
    by specialised messaging middleware products.

    0MQ sockets provide an abstraction of asynchronous message queues,
    multiple messaging patterns, message filtering (subscriptions),
    seamless access to multiple transport protocols and more.

    This library provides the Haskell language binding to 0MQ >= 4.x

category:               System, FFI
abi:                    0dbfd19b9cb9e67c452b90299958bf1d
exposed:                True
exposed-modules:
    Data.Restricted System.ZMQ4 System.ZMQ4.Internal
    System.ZMQ4.Internal.Base System.ZMQ4.Internal.Error
    System.ZMQ4.Monadic

import-dirs:            /usr/lib/ghc-9.4.8/site-local/zeromq4-haskell-0.8.0
library-dirs:           /usr/lib/ghc-9.4.8/site-local/zeromq4-haskell-0.8.0
library-dirs-static:    /usr/lib/ghc-9.4.8/site-local/zeromq4-haskell-0.8.0
dynamic-library-dirs:   /usr/lib
data-dir:               /usr/share/haskell-zeromq4-haskell
hs-libraries:           HSzeromq4-haskell-0.8.0-JO0XSkzXqq0Cr7Sh96ObYF
extra-libraries:        zmq
extra-libraries-static:
    zmq stdc++ rt gnutls gmp unistring atomic hogweed gmp nettle tasn1
    idn2 unistring p11-kit leancrypto sodium pthread pgm m

include-dirs:           /usr/include/p11-kit-1 /usr/include/pgm-5.3
depends:
    async-2.2.5-5zadbbqeCp9HahDgxNyESl base-4.17.2.1
    bytestring-0.11.5.3 containers-0.6.7 exceptions-0.10.5
    monad-control-1.0.3.1-Cwvaec5wBZ2EEdW1WlpKbT transformers-0.5.6.2
    transformers-base-0.4.6-F1VMXh3wf3eA4R3d16Dsbd

haddock-interfaces:
    /usr/share/doc/haskell-zeromq4-haskell/html/zeromq4-haskell.haddock

haddock-html:           /usr/share/doc/haskell-zeromq4-haskell/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

