#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 wide-word
version:              0.1.8.1
visibility:           public
id:                   wide-word-0.1.8.1-1VyjASIgN1V8lFvf9xq6oh
key:                  wide-word-0.1.8.1-1VyjASIgN1V8lFvf9xq6oh
license:              BSD-2-Clause
copyright:
    Copyright (c) 2017 Erik de Castro Lopo <erikd@mega-nerd.com>

maintainer:           erikd@mega-nerd.com
author:               Erik de Castro Lopo
stability:            provisional
homepage:             https://github.com/erikd/wide-word
synopsis:
    Data types for large but fixed width signed and unsigned integers

description:
    A library to provide data types for large (ie > 64 bits) but fixed width signed
    and unsigned integers with the usual typeclass instances to allow them to be used
    interchangeably with `Word64`.

    The types and operations are coded to be as fast as possible using strictness
    annotations, `INLINEABLE` pragmas and unboxed values and operations where
    appropriate.

category:             Data
abi:                  5e35aa7d8eb6e44150c1b3b50dc351a3
exposed:              True
exposed-modules:
    Data.WideWord Data.WideWord.Int128 Data.WideWord.Word128
    Data.WideWord.Word256 Data.WideWord.Word64

hidden-modules:       Data.WideWord.Compat
import-dirs:          /usr/lib/ghc-9.4.8/site-local/wide-word-0.1.8.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/wide-word-0.1.8.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/wide-word-0.1.8.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-wide-word
hs-libraries:         HSwide-word-0.1.8.1-1VyjASIgN1V8lFvf9xq6oh
depends:
    base-4.17.2.1 binary-0.8.9.1 deepseq-1.4.8.0
    hashable-1.4.5.0-46ofdJt9DgFJv5hpm4ccL9
    primitive-0.9.1.0-D2h8cSAG2AjKP2pRuhtPBO

haddock-interfaces:   /usr/share/doc/haskell-wide-word/html/wide-word.haddock
haddock-html:         /usr/share/doc/haskell-wide-word/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

