#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 what4
version:              1.6
visibility:           public
id:                   what4-1.6-74ac3Cnsv1S3U5yEQf848q
key:                  what4-1.6-74ac3Cnsv1S3U5yEQf848q
license:              BSD-3-Clause
copyright:            (c) Galois, Inc 2014-2023
maintainer:           rscott@galois.com, kquick@galois.com
author:               Galois Inc.
homepage:             https://github.com/GaloisInc/what4
synopsis:             Solver-agnostic symbolic values support for issuing queries
description:
    What4 is a generic library for representing values as symbolic formulae which may
    contain references to symbolic values, representing unknown variables.
    It provides support for communicating with a variety of SAT and SMT solvers,
    including Z3, CVC4, CVC5, Yices, Bitwuzla, Boolector, STP, and dReal.
    The data representation types make heavy use of GADT-style type indices
    to ensure type-correct manipulation of symbolic values.

category:             Formal Methods, Theorem Provers, Symbolic Computation, SMT
abi:                  ca4c0574cd2a8a8b645101b69ddca1f6
exposed:              True
exposed-modules:
    Test.Verification What4.BaseTypes What4.Concrete What4.Config
    What4.Expr What4.Expr.Allocator What4.Expr.App What4.Expr.AppTheory
    What4.Expr.ArrayUpdateMap What4.Expr.BoolMap What4.Expr.Builder
    What4.Expr.GroundEval What4.Expr.MATLAB What4.Expr.Simplify
    What4.Expr.StringSeq What4.Expr.UnaryBV
    What4.Expr.VarIdentification What4.Expr.WeightedSum What4.FloatMode
    What4.FunctionName What4.IndexLit What4.Interface
    What4.InterpretedFloatingPoint What4.LabeledPred What4.Panic
    What4.Partial What4.ProblemFeatures What4.ProgramLoc
    What4.Protocol.Online What4.Protocol.PolyRoot
    What4.Protocol.ReadDecimal What4.Protocol.SExp
    What4.Protocol.SMTLib2 What4.Protocol.SMTLib2.Parse
    What4.Protocol.SMTLib2.Response What4.Protocol.SMTLib2.Syntax
    What4.Protocol.SMTWriter What4.Protocol.VerilogWriter
    What4.Protocol.VerilogWriter.ABCVerilog
    What4.Protocol.VerilogWriter.AST
    What4.Protocol.VerilogWriter.Backend What4.SFloat What4.SWord
    What4.SatResult What4.SemiRing What4.Serialize.FastSExpr
    What4.Serialize.Log What4.Serialize.Normalize
    What4.Serialize.Parser What4.Serialize.Printer
    What4.Serialize.SETokens What4.Solver What4.Solver.Adapter
    What4.Solver.Bitwuzla What4.Solver.Boolector What4.Solver.CVC4
    What4.Solver.CVC5 What4.Solver.DReal What4.Solver.ExternalABC
    What4.Solver.STP What4.Solver.Yices What4.Solver.Z3
    What4.SpecialFunctions What4.Symbol What4.Utils.AbstractDomains
    What4.Utils.AnnotatedMap What4.Utils.Arithmetic
    What4.Utils.BVDomain What4.Utils.BVDomain.Arith
    What4.Utils.BVDomain.Bitwise What4.Utils.BVDomain.XOR
    What4.Utils.Complex What4.Utils.Endian What4.Utils.Environment
    What4.Utils.FloatHelpers What4.Utils.HandleReader
    What4.Utils.IncrHash What4.Utils.LeqMap What4.Utils.MonadST
    What4.Utils.OnlyIntRepr What4.Utils.Process
    What4.Utils.ResolveBounds.BV What4.Utils.Serialize
    What4.Utils.Streams What4.Utils.StringLiteral What4.Utils.Versions
    What4.Utils.Word16String What4.WordMap

import-dirs:          /usr/lib/ghc-9.4.8/site-local/what4-1.6
library-dirs:         /usr/lib/ghc-9.4.8/site-local/what4-1.6
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/what4-1.6
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-what4
hs-libraries:         HSwhat4-1.6-74ac3Cnsv1S3U5yEQf848q
depends:
    BoundedChan-1.0.3.0-LpypBc0eid95svZdMy7DB6
    async-2.2.5-Fwc3ABGHG7o8WWC3l3QDRi
    attoparsec-0.14.4-AfQEBsI4KfUBbsB9NxUVAd base-4.17.2.1
    bifunctors-5.6.2-FSG0dBjaJY55cmJ113Zetv
    bimap-0.5.0-IWHbwOX4mvXJx5V4AZnESK
    bv-sized-1.0.6-DCL5v90OTRIcD0WlsLfld bytestring-0.11.5.3
    concurrent-extra-0.7.0.12-IrNFE9GaSnaBKhMFF7vDv5
    config-value-0.8.3-AwfdtSmE9Y1aqPSXDWTLH containers-0.6.7
    deepseq-1.4.8.0 deriving-compat-0.6.7-A0qlo6AV0a58wTQsqeZZkD
    directory-1.3.7.1 exceptions-0.10.5 filepath-1.4.2.2
    fingertree-0.1.6.2-KgaN9n2WCbmStKKPC7nlw ghc-prim-0.9.1
    hashable-1.4.4.0-AmJtI56ndXc1GvGfBNNgwb
    hashtables-1.4.1-C3sVFDUsog7Hb8MZCpmJ2j
    io-streams-1.5.2.2-AzJvOi0FZyq61LfLhYn0Od
    lens-5.3.1-LF4jCoE0w776e2gq32lhyl libBF-0.6.6-IASBiOZXsi8aghieT1nRH
    megaparsec-9.7.0-9KX7uZoGWhIHAGHTH7OWSU mtl-2.2.2
    ordered-containers-0.2.4-EN6cFutD7X2DFUxv6BLzZy
    panic-0.4.0.1-9Mho20XcACeAG1iUCpMASP
    parameterized-utils-2.1.10.0-9RekIEUHOIL7bso4BB2zC4 parsec-3.1.16.1
    prettyprinter-1.7.1-5xgqmGXqgSr2RPa1NTsZyQ process-1.6.18.0
    s-cargot-0.1.6.0-GOvcYxQ6Be43FLPZBm4DL2
    scientific-0.3.8.0-KXoba1fOMYH676R2WXZfYW stm-2.5.1.0
    template-haskell-2.19.0.0 temporary-1.3-836zY2cPz8HAaBXH2WMEd1
    text-2.0.2 th-lift-0.8.5-3bCWMcLwp8dEXoRnv4Yrhx
    th-lift-instances-0.1.20-75e0bbi0poAC0AylMFebPe time-1.12.2
    transformers-0.5.6.2 unliftio-0.2.25.1-6SrDYM6H10EJJ9ZQAtB2Dj
    unordered-containers-0.2.20-3NcLl7S6t7kAuh7l4Ieeoo
    utf8-string-1.0.2-FAQSGuIUGqDKZx6mH04y15
    vector-0.13.2.0-CQ8QMV1t4PN5YFZtNXivGS
    versions-6.0.8-Cza9ogubvQrEyvnIkagiLM
    zenc-0.1.2-LVcOUQ1X5ANTzv7g9kypd

haddock-interfaces:   /usr/share/doc/haskell-what4/html/what4.haddock
haddock-html:         /usr/share/doc/haskell-what4/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

