#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 what4
version:              1.6
visibility:           public
id:                   what4-1.6-EmR056cSjdu1FYsMNREAwy
key:                  what4-1.6-EmR056cSjdu1FYsMNREAwy
license:              BSD-3-Clause
copyright:            (c) Galois, Inc 2014-2023
maintainer:           rscott@galois.com, kquick@galois.com
author:               Galois Inc.
homepage:             https://github.com/GaloisInc/what4
synopsis:             Solver-agnostic symbolic values support for issuing queries
description:
    What4 is a generic library for representing values as symbolic formulae which may
    contain references to symbolic values, representing unknown variables.
    It provides support for communicating with a variety of SAT and SMT solvers,
    including Z3, CVC4, CVC5, Yices, Bitwuzla, Boolector, STP, and dReal.
    The data representation types make heavy use of GADT-style type indices
    to ensure type-correct manipulation of symbolic values.

category:             Formal Methods, Theorem Provers, Symbolic Computation, SMT
abi:                  c86f4c55960b67ba38afde7a1d47cdb7
exposed:              True
exposed-modules:
    Test.Verification What4.BaseTypes What4.Concrete What4.Config
    What4.Expr What4.Expr.Allocator What4.Expr.App What4.Expr.AppTheory
    What4.Expr.ArrayUpdateMap What4.Expr.BoolMap What4.Expr.Builder
    What4.Expr.GroundEval What4.Expr.MATLAB What4.Expr.Simplify
    What4.Expr.StringSeq What4.Expr.UnaryBV
    What4.Expr.VarIdentification What4.Expr.WeightedSum What4.FloatMode
    What4.FunctionName What4.IndexLit What4.Interface
    What4.InterpretedFloatingPoint What4.LabeledPred What4.Panic
    What4.Partial What4.ProblemFeatures What4.ProgramLoc
    What4.Protocol.Online What4.Protocol.PolyRoot
    What4.Protocol.ReadDecimal What4.Protocol.SExp
    What4.Protocol.SMTLib2 What4.Protocol.SMTLib2.Parse
    What4.Protocol.SMTLib2.Response What4.Protocol.SMTLib2.Syntax
    What4.Protocol.SMTWriter What4.Protocol.VerilogWriter
    What4.Protocol.VerilogWriter.ABCVerilog
    What4.Protocol.VerilogWriter.AST
    What4.Protocol.VerilogWriter.Backend What4.SFloat What4.SWord
    What4.SatResult What4.SemiRing What4.Serialize.FastSExpr
    What4.Serialize.Log What4.Serialize.Normalize
    What4.Serialize.Parser What4.Serialize.Printer
    What4.Serialize.SETokens What4.Solver What4.Solver.Adapter
    What4.Solver.Bitwuzla What4.Solver.Boolector What4.Solver.CVC4
    What4.Solver.CVC5 What4.Solver.DReal What4.Solver.ExternalABC
    What4.Solver.STP What4.Solver.Yices What4.Solver.Z3
    What4.SpecialFunctions What4.Symbol What4.Utils.AbstractDomains
    What4.Utils.AnnotatedMap What4.Utils.Arithmetic
    What4.Utils.BVDomain What4.Utils.BVDomain.Arith
    What4.Utils.BVDomain.Bitwise What4.Utils.BVDomain.XOR
    What4.Utils.Complex What4.Utils.Endian What4.Utils.Environment
    What4.Utils.FloatHelpers What4.Utils.HandleReader
    What4.Utils.IncrHash What4.Utils.LeqMap What4.Utils.MonadST
    What4.Utils.OnlyIntRepr What4.Utils.Process
    What4.Utils.ResolveBounds.BV What4.Utils.Serialize
    What4.Utils.Streams What4.Utils.StringLiteral What4.Utils.Versions
    What4.Utils.Word16String What4.WordMap

import-dirs:          /usr/lib/ghc-9.4.8/site-local/what4-1.6
library-dirs:         /usr/lib/ghc-9.4.8/site-local/what4-1.6
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/what4-1.6
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-what4
hs-libraries:         HSwhat4-1.6-EmR056cSjdu1FYsMNREAwy
depends:
    BoundedChan-1.0.3.0-LpypBc0eid95svZdMy7DB6
    async-2.2.5-Cu6iyHAzE8GPfJTsQBFL9
    attoparsec-0.14.4-EuJHdCyQx9qFeM6j3QZsTf base-4.17.2.1
    bifunctors-5.6.2-DCTJLPxdXjU9uJkXX2pXQl
    bimap-0.5.0-4M3RB4wVuIJ3HEmZusRsTk
    bv-sized-1.0.6-6d4NHC9NfubLW0YsK2YV97 bytestring-0.11.5.3
    concurrent-extra-0.7.0.12-9Fd5dT0JI305d01kvsEoIp
    config-value-0.8.3-AwfdtSmE9Y1aqPSXDWTLH containers-0.6.7
    deepseq-1.4.8.0 deriving-compat-0.6.7-4tivW0QhJhC4sfjLVKf2Qp
    directory-1.3.7.1 exceptions-0.10.5 filepath-1.4.2.2
    fingertree-0.1.6.2-5bwCRqPSPONFRvZK1Xdkww ghc-prim-0.9.1
    hashable-1.4.4.0-92QHxum7zjW25fH5Mdbvto
    hashtables-1.4.1-Hd0FQtJQkV2WoNJRcC9oq
    io-streams-1.5.2.2-C922vE7sC8ZE1UuSOYKgyJ
    lens-5.3.1-LjfZJ7QVgZYGOTr5fwppHy
    libBF-0.6.6-BauFL8h3ndv3yDEjw6FL5L
    megaparsec-9.7.0-KfxQnMxH7036P9QuPFea8D mtl-2.2.2
    ordered-containers-0.2.4-2cYDao4HtHxKkMNwoDI5d7
    panic-0.4.0.1-3HuynR94lzrCKtPGBGvV9o
    parameterized-utils-2.1.10.0-LipUHbWRZon24vmDfOEkA7 parsec-3.1.16.1
    prettyprinter-1.7.1-27Ta3g9m3VQHgx6FjDiyXu process-1.6.18.0
    s-cargot-0.1.6.0-Io2eoTJOl1aJakLzwZbXxJ
    scientific-0.3.8.0-6uPUyX2SLNQ5uEuI9iq9EK stm-2.5.1.0
    template-haskell-2.19.0.0 temporary-1.3-AgnyQJqoH2tBVE9T1YksW9
    text-2.0.2 th-lift-0.8.5-3bCWMcLwp8dEXoRnv4Yrhx
    th-lift-instances-0.1.20-1ltNaZBsRyLHsoURdEtsZi time-1.12.2
    transformers-0.5.6.2 unliftio-0.2.25.1-7tyRVJx8ZNHIaUyarAToDA
    unordered-containers-0.2.20-L0GY6JfHBKC8QjVdSVYiO8
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm
    vector-0.13.2.0-LTUcBi4LXgv7CSERMHHzQp
    versions-6.0.8-98Eg98RpAzy3iKWN0FIfVq
    zenc-0.1.2-HOwA52a2qVc9EyMObZ5YEI

haddock-interfaces:   /usr/share/doc/haskell-what4/html/what4.haddock
haddock-html:         /usr/share/doc/haskell-what4/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

