#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 wai-extra
version:              3.1.17
visibility:           public
id:                   wai-extra-3.1.17-8nCNR940FkpGdBLxLOLRvO
key:                  wai-extra-3.1.17-8nCNR940FkpGdBLxLOLRvO
license:              MIT
maintainer:           michael@snoyman.com
author:               Michael Snoyman
stability:            Stable
homepage:             http://github.com/yesodweb/wai
synopsis:             Provides some basic WAI handlers and middleware.
description:
    Provides basic WAI handler and middleware functionality:

    * WAI Testing Framework

    Hspec testing facilities and helpers for WAI.

    * Event Source/Event Stream

    Send server events to the client. Compatible with the JavaScript
    EventSource API.

    * Accept Override

    Override the Accept header in a request. Special handling for the
    _accept query parameter (which is used throughout WAI override the
    Accept header).

    * Add Headers

    WAI Middleware for adding arbitrary headers to an HTTP request.

    * Clean Path

    Clean a request path to a canonical form.

    * Combine Headers

    Combine duplicate headers into one.

    * GZip Compression

    Negotiate HTTP payload gzip compression.

    * Health check endpoint

    Add an empty health check endpoint.

    * HTTP Basic Authentication

    WAI Basic Authentication Middleware which uses Authorization header.

    * JSONP

    \"JSON with Padding\" middleware. Automatic wrapping of JSON
    responses to convert into JSONP.

    * Method Override / Post

    Allows overriding of the HTTP request method via the _method query string
    parameter.

    * Request Logging

    Request logging middleware for development and production environments

    * Request Rewrite

    Rewrite request path info based on a custom conversion rules.

    * Select

    Dynamically choose between Middlewares.

    * Stream Files

    Convert ResponseFile type responses into ResponseStream type.

    * Virtual Host

    Redirect incoming requests to a new host based on custom rules.


    API docs and the README are available at <http://www.stackage.org/package/wai-extra>.

category:             Web
abi:                  807a25203ab25fbb97690cb59b83fb1f
exposed:              True
exposed-modules:
    Network.Wai.EventSource Network.Wai.EventSource.EventStream
    Network.Wai.Handler.CGI Network.Wai.Handler.SCGI Network.Wai.Header
    Network.Wai.Middleware.AcceptOverride
    Network.Wai.Middleware.AddHeaders Network.Wai.Middleware.Approot
    Network.Wai.Middleware.Autohead Network.Wai.Middleware.CleanPath
    Network.Wai.Middleware.CombineHeaders
    Network.Wai.Middleware.ForceDomain Network.Wai.Middleware.ForceSSL
    Network.Wai.Middleware.Gzip
    Network.Wai.Middleware.HealthCheckEndpoint
    Network.Wai.Middleware.HttpAuth Network.Wai.Middleware.Jsonp
    Network.Wai.Middleware.Local Network.Wai.Middleware.MethodOverride
    Network.Wai.Middleware.MethodOverridePost
    Network.Wai.Middleware.RealIp Network.Wai.Middleware.RequestLogger
    Network.Wai.Middleware.RequestLogger.JSON
    Network.Wai.Middleware.RequestSizeLimit
    Network.Wai.Middleware.RequestSizeLimit.Internal
    Network.Wai.Middleware.Rewrite Network.Wai.Middleware.Routed
    Network.Wai.Middleware.Select Network.Wai.Middleware.StreamFile
    Network.Wai.Middleware.StripHeaders Network.Wai.Middleware.Timeout
    Network.Wai.Middleware.ValidateHeaders Network.Wai.Middleware.Vhost
    Network.Wai.Parse Network.Wai.Request Network.Wai.Test
    Network.Wai.Test.Internal Network.Wai.UrlMap

hidden-modules:
    Network.Wai.Middleware.RequestLogger.Internal Network.Wai.Util

import-dirs:          /usr/lib/ghc-9.4.8/site-local/wai-extra-3.1.17
library-dirs:         /usr/lib/ghc-9.4.8/site-local/wai-extra-3.1.17
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/wai-extra-3.1.17
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-wai-extra
hs-libraries:         HSwai-extra-3.1.17-8nCNR940FkpGdBLxLOLRvO
depends:
    HUnit-1.6.2.0-Hv4JJKlmVQBCBbuJaEWmVH
    aeson-2.1.2.1-5gViDrHjeNhDfT19MwgeMT
    ansi-terminal-1.0.2-7iJd05aKggE3LiIfKfS0OR base-4.17.2.1
    base64-bytestring-1.2.1.0-92IFzWt15c2BW0SweP4Os1
    bytestring-0.11.5.3 call-stack-0.4.0-GRuL9lRThh8EyvG9NSK1NH
    case-insensitive-1.2.1.0-D4Bx6jK2099tFJcppXDxv containers-0.6.7
    cookie-0.4.6-4KcZJbma3z5GIFijXOzknm
    data-default-0.7.1.2-86VyjkfSCk63mGj7Z05i2D directory-1.3.7.1
    fast-logger-3.2.3-EynU4MfMsHVFyzHM1b4WJJ
    http-types-0.12.4-845zQBf8K2R8QZqh3scBqV
    iproute-1.7.15-AOKi7gMMo6t46atMSombo8
    network-3.1.4.0-EpGtkoqQTWdJPJAj8Thqiz
    resourcet-1.2.6-60kBeMKLYLU7DGwHkUvFW1
    streaming-commons-0.2.3.0-34wBwxBZPl06oHoRiEv8KR text-2.0.2
    time-1.12.2 transformers-0.5.6.2 unix-2.7.3
    vault-0.3.1.5-LDPoXEF5EXj6cZT6TUOepK
    wai-3.2.4-41iNGcJSwNvEUgUKaMQRRA
    wai-logger-2.5.0-76EjVeqnyiDIz9HJaMAGG4
    warp-3.3.30-KUCEwGn4TuyLVm9l2BLxF8
    word8-0.1.3-H2XlNdB8B5CGwrdA9Iis9I

haddock-interfaces:   /usr/share/doc/haskell-wai-extra/html/wai-extra.haddock
haddock-html:         /usr/share/doc/haskell-wai-extra/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

