#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 vector
version:              0.13.2.0
visibility:           public
id:                   vector-0.13.2.0-7ng4g94OT6G5h8WbLpDlXn
key:                  vector-0.13.2.0-7ng4g94OT6G5h8WbLpDlXn
license:              BSD-3-Clause
copyright:
    (c) Roman Leshchinskiy 2008-2012,
        Alexey Kuleshevich 2020-2022,
        Aleksey Khudyakov 2020-2022,
        Andrew Lelechenko 2020-2022

maintainer:
    Haskell Libraries Team <libraries@haskell.org>
    Alexey Kuleshevich <alexey@kuleshevi.ch>,
    Aleksey Khudyakov <alexey.skladnoy@gmail.com>,
    Andrew Lelechenko <andrew.lelechenko@gmail.com>

author:               Roman Leshchinskiy <rl@cse.unsw.edu.au>
homepage:             https://github.com/haskell/vector
synopsis:             Efficient Arrays
description:
    .
    An efficient implementation of @Int@-indexed arrays (both mutable
    and immutable), with a powerful loop optimisation framework .
    .
    It is structured as follows:
    .
    ["Data.Vector"] Boxed vectors of arbitrary types.
    .
    ["Data.Vector.Unboxed"] Unboxed vectors with an adaptive
    representation based on data type families.
    .
    ["Data.Vector.Storable"] Unboxed vectors of '\''Storable'\'' types.
    .
    ["Data.Vector.Primitive"] Unboxed vectors of primitive types as
    defined by the @primitive@ package. "Data.Vector.Unboxed" is more
    flexible at no performance cost.
    .
    ["Data.Vector.Generic"] Generic interface to the vector types.
    .
    There is also a (draft) tutorial on common uses of vector.
    .
    * <http://haskell.org/haskellwiki/Numeric_Haskell:_A_Vector_Tutorial>

category:             Data, Data Structures
abi:                  2397a8bc39e01e5c961ad749b3980466
exposed:              True
exposed-modules:
    Data.Vector Data.Vector.Fusion.Bundle
    Data.Vector.Fusion.Bundle.Monadic Data.Vector.Fusion.Bundle.Size
    Data.Vector.Fusion.Stream.Monadic Data.Vector.Fusion.Util
    Data.Vector.Generic Data.Vector.Generic.Base
    Data.Vector.Generic.Mutable Data.Vector.Generic.Mutable.Base
    Data.Vector.Generic.New Data.Vector.Internal.Check
    Data.Vector.Mutable Data.Vector.Primitive
    Data.Vector.Primitive.Mutable Data.Vector.Storable
    Data.Vector.Storable.Internal Data.Vector.Storable.Mutable
    Data.Vector.Strict Data.Vector.Strict.Mutable Data.Vector.Unboxed
    Data.Vector.Unboxed.Base Data.Vector.Unboxed.Mutable

import-dirs:          /usr/lib/ghc-9.4.8/site-local/vector-0.13.2.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/vector-0.13.2.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/vector-0.13.2.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-vector
hs-libraries:         HSvector-0.13.2.0-7ng4g94OT6G5h8WbLpDlXn
include-dirs:         /usr/lib/ghc-9.4.8/site-local/vector-0.13.2.0/include
depends:
    base-4.17.2.1 deepseq-1.4.8.0
    primitive-0.9.1.0-4og3N5b6tAb1VUfCmYprp3
    vector-stream-0.1.0.1-F03bfhC0HhqL26lQDSs4vb

haddock-interfaces:   /usr/share/doc/haskell-vector/html/vector.haddock
haddock-html:         /usr/share/doc/haskell-vector/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 z-vector-z-benchmarks-O2
version:              0.13.2.0
package-name:         vector
lib-name:             benchmarks-O2
visibility:           public
id:                   vector-0.13.2.0-Aidq1u3tUq61sZ9gDqosJM-benchmarks-O2
key:                  vector-0.13.2.0-Aidq1u3tUq61sZ9gDqosJM-benchmarks-O2
license:              BSD-3-Clause
copyright:
    (c) Roman Leshchinskiy 2008-2012,
        Alexey Kuleshevich 2020-2022,
        Aleksey Khudyakov 2020-2022,
        Andrew Lelechenko 2020-2022

maintainer:
    Haskell Libraries Team <libraries@haskell.org>
    Alexey Kuleshevich <alexey@kuleshevi.ch>,
    Aleksey Khudyakov <alexey.skladnoy@gmail.com>,
    Andrew Lelechenko <andrew.lelechenko@gmail.com>

author:               Roman Leshchinskiy <rl@cse.unsw.edu.au>
homepage:             https://github.com/haskell/vector
synopsis:             Efficient Arrays
description:
    .
    An efficient implementation of @Int@-indexed arrays (both mutable
    and immutable), with a powerful loop optimisation framework .
    .
    It is structured as follows:
    .
    ["Data.Vector"] Boxed vectors of arbitrary types.
    .
    ["Data.Vector.Unboxed"] Unboxed vectors with an adaptive
    representation based on data type families.
    .
    ["Data.Vector.Storable"] Unboxed vectors of '\''Storable'\'' types.
    .
    ["Data.Vector.Primitive"] Unboxed vectors of primitive types as
    defined by the @primitive@ package. "Data.Vector.Unboxed" is more
    flexible at no performance cost.
    .
    ["Data.Vector.Generic"] Generic interface to the vector types.
    .
    There is also a (draft) tutorial on common uses of vector.
    .
    * <http://haskell.org/haskellwiki/Numeric_Haskell:_A_Vector_Tutorial>

category:             Data, Data Structures
abi:                  5267557e88cc1fc4039c00eabefe1de4
exposed-modules:
    Bench.Vector.Algo.AwShCC Bench.Vector.Algo.FindIndexR
    Bench.Vector.Algo.HybCC Bench.Vector.Algo.Leaffix
    Bench.Vector.Algo.ListRank Bench.Vector.Algo.MutableSet
    Bench.Vector.Algo.NextPermutation Bench.Vector.Algo.Quickhull
    Bench.Vector.Algo.Rootfix Bench.Vector.Algo.Spectral
    Bench.Vector.Algo.Tridiag Bench.Vector.Tasty
    Bench.Vector.TestData.Graph Bench.Vector.TestData.ParenTree

import-dirs:          /usr/lib/ghc-9.4.8/site-local/vector-0.13.2.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/vector-0.13.2.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/vector-0.13.2.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-vector
hs-libraries:         HSvector-0.13.2.0-Aidq1u3tUq61sZ9gDqosJM-benchmarks-O2
depends:
    base-4.17.2.1 random-1.2.1.3-6W1EVTTDyQHT39k7sQsHZ
    tasty-1.5-RbhPPDqNkJC7VfOGVeKVg
    vector-0.13.2.0-7ng4g94OT6G5h8WbLpDlXn

haddock-interfaces:   /usr/share/doc/haskell-vector/html/vector.haddock
haddock-html:         /usr/share/doc/haskell-vector/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

