#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 vec
version:              0.5
visibility:           public
id:                   vec-0.5-2FB7vQjpLu7EacqQA02VLU
key:                  vec-0.5-2FB7vQjpLu7EacqQA02VLU
license:              BSD-3-Clause
copyright:            (c) 2017-2021 Oleg Grenrus
maintainer:           Oleg.Grenrus <oleg.grenrus@iki.fi>
author:               Oleg Grenrus <oleg.grenrus@iki.fi>
homepage:             https://github.com/phadej/vec
synopsis:             Vec: length-indexed (sized) list
description:
    This package provides length-indexed (sized) lists, also known as vectors.

    @
    data Vec n a where
    \    VNil  :: Vec '\''Nat.Z a
    \    (:::) :: a -> Vec n a -> Vec ('\''Nat.S n) a
    @

    The functions are implemented in four flavours:

    * __naive__: with explicit recursion. It'\''s simple, constraint-less, yet slow.

    * __pull__: using @Fin n -> a@ representation, which fuses well,
    but makes some programs hard to write. And

    * __data-family__: which allows lazy pattern matching

    * __inline__: which exploits how GHC dictionary inlining works, unrolling
    recursion if the size of '\''Vec'\'' is known statically.

    As best approach depends on the application, @vec@ doesn'\''t do any magic
    transformation. Benchmark your code.

    This package uses [fin](https://hackage.haskell.org/package/fin), i.e. not @GHC.TypeLits@, for indexes.

    For @lens@ or @optics@ support see [vec-lens](https://hackage.haskell.org/package/vec-lens) and [vec-optics](https://hackage.haskell.org/package/vec-optics) packages respectively.

    See [Hasochism: the pleasure and pain of dependently typed haskell programming](https://doi.org/10.1145/2503778.2503786)
    by Sam Lindley and Conor McBride for answers to /how/ and /why/.
    Read [APLicative Programming with Naperian Functors](https://doi.org/10.1007/978-3-662-54434-1_21)
    by Jeremy Gibbons for (not so) different ones.

    === Similar packages

    * [linear](https://hackage.haskell.org/package/linear) has '\''V'\'' type,
    which uses '\''Vector'\'' from @vector@ package as backing store.
    @Vec@ is a real GADT, but tries to provide as many useful instances (upto @lens@).

    * [vector-sized](https://hackage.haskell.org/package/vector-sized)
    Great package using @GHC.TypeLits@. Current version (0.6.1.0) uses
    @finite-typelits@ and @Int@ indexes.

    * [sized-vector](https://hackage.haskell.org/package/sized-vector) depends
    on @singletons@ package. @vec@ isn'\''t light on dependencies either,
    but try to provide wide GHC support.

    * [fixed-vector](https://hackage.haskell.org/package/fixed-vector)

    * [sized](https://hackage.haskell.org/package/sized) also depends
    on a @singletons@ package. The @Sized f n a@ type is generalisation of
    @linear@'\''s @V@ for any @ListLike@.

    * [clash-prelude](https://hackage.haskell.org/package/clash-prelude)
    is a kitchen sink package, which has @CLaSH.Sized.Vector@ module.
    Also depends on @singletons@.

category:             Data, Dependent Types
abi:                  d9c72abf83798c17295d559a859d9558
exposed:              True
exposed-modules:
    Data.Vec.DataFamily.SpineStrict Data.Vec.Lazy Data.Vec.Lazy.Inline
    Data.Vec.Pull

hidden-modules:       Control.Lens.Yocto SafeCompat
import-dirs:          /usr/lib/ghc-9.4.8/site-local/vec-0.5
library-dirs:         /usr/lib/ghc-9.4.8/site-local/vec-0.5
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/vec-0.5
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-vec
hs-libraries:         HSvec-0.5-2FB7vQjpLu7EacqQA02VLU
depends:
    QuickCheck-2.14.3-76HC5XzyauqDQFZ8BHcZeC
    adjunctions-4.4.3-7rDhzlXTnuxCPKM8uAVj23 base-4.17.2.1
    boring-0.2.2-HI9VvaC9JR142cnMpyID0P deepseq-1.4.8.0
    distributive-0.6.2.1-AaJ1Rc5A0vxBwbHEYFEoTm
    fin-0.3.2-EahR1mObaQyD8zhnFFcgEB
    hashable-1.4.4.0-1zcla4qwUGf6ADT5z5m7Nb
    indexed-traversable-0.1.4-1jVJAb9Ott1EiIUD50SH50
    semigroupoids-6.0.1-8sKf1o1a2c6K4GAi4qlWGt transformers-0.5.6.2

haddock-interfaces:   /usr/share/doc/haskell-vec/html/vec.haddock
haddock-html:         /usr/share/doc/haskell-vec/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

