#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 uuid-types
version:              1.0.6
visibility:           public
id:                   uuid-types-1.0.6-HsEJaNxEgFx55hazgJEfvI
key:                  uuid-types-1.0.6-HsEJaNxEgFx55hazgJEfvI
license:              BSD-3-Clause
copyright:
    (c) 2017-2018 Herbert Valerio Riedel
    (c) 2008-2014 Antoine Latter

maintainer:           Oleg Grenrus <oleg.grenrus@iki.fi>
author:               Antoine Latter
homepage:             https://github.com/haskell-hvr/uuid
synopsis:             Type definitions for Universally Unique Identifiers
description:
    This library contains type definitions for
    <https://en.wikipedia.org/wiki/UUID Universally Unique Identifiers (UUID)>
    (as specified in
    <http://tools.ietf.org/html/rfc4122 RFC 4122>)
    and basic conversion functions.

    See also the <https://hackage.haskell.org/package/uuid '\''uuid'\'' package>
    providing a high-level API for managing the different UUID versions.

category:             Data
abi:                  ee798b4523d909e12f20dbefe78c2ca7
exposed:              True
exposed-modules:
    Data.UUID.Types Data.UUID.Types.Internal
    Data.UUID.Types.Internal.Builder

import-dirs:          /usr/lib/ghc-9.4.8/site-local/uuid-types-1.0.6
library-dirs:         /usr/lib/ghc-9.4.8/site-local/uuid-types-1.0.6
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/uuid-types-1.0.6
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-uuid-types
hs-libraries:         HSuuid-types-1.0.6-HsEJaNxEgFx55hazgJEfvI
depends:
    base-4.17.2.1 binary-0.8.9.1 bytestring-0.11.5.3 deepseq-1.4.8.0
    hashable-1.4.4.0-HmFtE5Wyl97MxSGTvKCoh
    random-1.2.1.3-BJci0ZIHWY7JJvOpU5NHzK template-haskell-2.19.0.0
    text-2.0.2

haddock-interfaces:   /usr/share/doc/haskell-uuid-types/html/uuid-types.haddock
haddock-html:         /usr/share/doc/haskell-uuid-types/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

