#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 uuid
version:              1.3.16
visibility:           public
id:                   uuid-1.3.16-CCVcaow8w0JlmCECzu7oG
key:                  uuid-1.3.16-CCVcaow8w0JlmCECzu7oG
license:              BSD-3-Clause
copyright:            (c) 2008-2014 Antoine Latter
maintainer:           Oleg Grenrus <oleg.grenrus@iki.fi>
author:               Antoine Latter
homepage:             https://github.com/haskell-hvr/uuid
synopsis:
    For creating, comparing, parsing and printing Universally Unique Identifiers

description:
    This library is useful for creating, comparing, parsing and
    printing Universally Unique Identifiers.

    See <http://en.wikipedia.org/wiki/UUID> for the general idea.

category:             Data
abi:                  f9292b7ba476b674696179a411ef63b6
exposed:              True
exposed-modules:
    Data.UUID Data.UUID.Util Data.UUID.V1 Data.UUID.V3 Data.UUID.V4
    Data.UUID.V5

hidden-modules:       Data.UUID.Named Data.Word.Util
import-dirs:          /usr/lib/ghc-9.4.8/site-local/uuid-1.3.16
library-dirs:         /usr/lib/ghc-9.4.8/site-local/uuid-1.3.16
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/uuid-1.3.16
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-uuid
hs-libraries:         HSuuid-1.3.16-CCVcaow8w0JlmCECzu7oG
depends:
    base-4.17.2.1 binary-0.8.9.1 bytestring-0.11.5.3
    cryptohash-md5-0.11.101.0-2qE5bK1odScLplZfG3wAKC
    cryptohash-sha1-0.11.101.0-2hnzw6T9KJl3iTplCE92oC
    entropy-0.4.1.11-KgGl1Y7Pn5mDV1IyWdAGFR
    network-info-0.2.1-DF9aJuNW45HC0966sT94Vy
    random-1.2.1.3-8qBO4jKvrkh2o7oxGJ8dv text-2.0.2 time-1.12.2
    uuid-types-1.0.6-IMLQEcXeMcbHpik3Tf72BT

haddock-interfaces:   /usr/share/doc/haskell-uuid/html/uuid.haddock
haddock-html:         /usr/share/doc/haskell-uuid/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

