#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 universe-reverse-instances
version:              1.1.2
visibility:           public
id:                   universe-reverse-instances-1.1.2-GhCZQ1KYo014fO26hZbzMM
key:                  universe-reverse-instances-1.1.2-GhCZQ1KYo014fO26hZbzMM
license:              BSD-3-Clause
copyright:            Daniel Wagner 2014
maintainer:           me@dmwit.com
author:               Daniel Wagner
homepage:             https://github.com/dmwit/universe
synopsis:
    Instances of standard classes that are made possible by enumerations

description:
    For example this package provides a @Eq (a -> b)@ instance:

    @
    instance (Finite a, Eq b) => Eq (a -> b) where
    f == g = and [f x == g x | x <- universeF]
    @

category:             Data
abi:                  79d68d10516c27ec516ace22608f28b8
exposed:              True
exposed-modules:
    Data.Universe.Instances.Eq Data.Universe.Instances.Ord
    Data.Universe.Instances.Read Data.Universe.Instances.Show
    Data.Universe.Instances.Traversable

import-dirs:
    /usr/lib/ghc-9.4.8/site-local/universe-reverse-instances-1.1.2

library-dirs:
    /usr/lib/ghc-9.4.8/site-local/universe-reverse-instances-1.1.2

library-dirs-static:
    /usr/lib/ghc-9.4.8/site-local/universe-reverse-instances-1.1.2

dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-universe-reverse-instances
hs-libraries:         HSuniverse-reverse-instances-1.1.2-GhCZQ1KYo014fO26hZbzMM
depends:
    base-4.17.2.1 containers-0.6.7
    universe-base-1.1.4-1hYWKrQ34F9F2Z1Md4HnUe

haddock-interfaces:
    /usr/share/doc/haskell-universe-reverse-instances/html/universe-reverse-instances.haddock

haddock-html:         /usr/share/doc/haskell-universe-reverse-instances/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

