#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 unicode-collation
version:              0.1.3.6
visibility:           public
id:                   unicode-collation-0.1.3.6-CGJ44c1fFOyF0XIqZtKifM
key:                  unicode-collation-0.1.3.6-CGJ44c1fFOyF0XIqZtKifM
license:              BSD-2-Clause
copyright:            2021 John MacFarlane
maintainer:           John MacFarlane <jgm@berkeley.edu>
author:               John MacFarlane
homepage:             https://github.com/jgm/unicode-collation
synopsis:             Haskell implementation of the Unicode Collation Algorithm
description:
    This library provides a pure Haskell implementation of
    the Unicode Collation Algorithm described at
    <http://www.unicode.org/reports/tr10/>.  It is not
    as fully-featured or as performant as @text-icu@, but
    it avoids a dependency on a large C library.
    Locale-specific tailorings are also provided.

category:             Text
abi:                  f8fec4069dd250cca9269a69076f7a46
exposed:              True
exposed-modules:      Text.Collate Text.Collate.Lang Text.Collate.Normalize
hidden-modules:
    Text.Collate.Trie Text.Collate.Collation Text.Collate.Collator
    Text.Collate.CanonicalCombiningClass Text.Collate.TH
    Text.Collate.Tailorings Text.Collate.UnicodeData

import-dirs:          /usr/lib/ghc-9.4.8/site-local/unicode-collation-0.1.3.6
library-dirs:         /usr/lib/ghc-9.4.8/site-local/unicode-collation-0.1.3.6
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/unicode-collation-0.1.3.6
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-unicode-collation
hs-libraries:         HSunicode-collation-0.1.3.6-CGJ44c1fFOyF0XIqZtKifM
depends:
    base-4.17.2.1 binary-0.8.9.1 bytestring-0.11.5.3 containers-0.6.7
    parsec-3.1.16.1 template-haskell-2.19.0.0 text-2.0.2
    th-lift-instances-0.1.20-IwebiWZ4aGgFgZ9YEdV5Wl

haddock-interfaces:
    /usr/share/doc/haskell-unicode-collation/html/unicode-collation.haddock

haddock-html:         /usr/share/doc/haskell-unicode-collation/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

