#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 turtle
version:              1.6.2
visibility:           public
id:                   turtle-1.6.2-DaxGuiJBDhq5HHUhMipWUl
key:                  turtle-1.6.2-DaxGuiJBDhq5HHUhMipWUl
license:              BSD-3-Clause
copyright:            2015 Gabriella Gonzalez
maintainer:           GenuineGabriella@gmail.com
author:               Gabriella Gonzalez
synopsis:             Shell programming, Haskell-style
description:
    @turtle@ is a reimplementation of the Unix command line environment
    in Haskell so that you can use Haskell as both a shell and a scripting
    language.

    Features include:

    * Batteries included: Command an extended suite of predefined utilities

    * Interoperability: You can still run external shell commands

    * Portability: Works on Windows, OS X, and Linux

    * Exception safety: Safely acquire and release resources

    * Streaming: Transform or fold command output in constant space

    * Patterns: Use typed regular expressions that can parse structured values

    * Formatting: Type-safe @printf@-style text formatting

    * Modern: Supports @text@

    Read "Turtle.Tutorial" for a detailed tutorial or "Turtle.Prelude" for a
    quick-start guide

    @turtle@ is designed to be beginner-friendly, but as a result lacks certain
    features, like tracing commands.  If you feel comfortable using @turtle@
    then you should also check out the @Shelly@ library which provides similar
    functionality.

category:             System
abi:                  e609d236ea6ac1921a401a8e51919bd3
exposed:              True
exposed-modules:
    Turtle Turtle.Bytes Turtle.Format Turtle.Line Turtle.Options
    Turtle.Pattern Turtle.Prelude Turtle.Shell Turtle.Tutorial

hidden-modules:       Turtle.Internal
import-dirs:          /usr/lib/ghc-9.4.8/site-local/turtle-1.6.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/turtle-1.6.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/turtle-1.6.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-turtle
hs-libraries:         HSturtle-1.6.2-DaxGuiJBDhq5HHUhMipWUl
depends:
    ansi-wl-pprint-1.0.2-Dv4BsTDVZ037OUre4opsdx
    async-2.2.5-BbhpjNcetBn7sq4yuFYnd1 base-4.17.2.1
    bytestring-0.11.5.3 clock-0.8.4-9W7MoycyDccHFSizRWb1v9
    containers-0.6.7 directory-1.3.7.1 exceptions-0.10.5
    filepath-1.4.2.2 foldl-1.4.18-KhoxNgZnXdb2lEhyhyZkQj
    hostname-1.0-LeTF2MpavibDHBTJAkCOwY
    managed-1.0.10-CrvLNY2sLDT8jZhIlothny
    optional-args-1.0.2-3D00KgSuB6i2d4bFhkB0pW
    optparse-applicative-0.18.1.0-CKCQVkeW052FlPJiFlkCaf
    process-1.6.18.0 stm-2.5.1.0
    streaming-commons-0.2.3.0-g3TQcCBU6BNOSjTKAotw
    temporary-1.3-Bz9UHoeAgBV21I7419KVlH text-2.0.2 time-1.12.2
    transformers-0.5.6.2 unix-2.7.3
    unix-compat-0.7.4.1-HfukfXMXV6LHwjUE321L3t

haddock-interfaces:   /usr/share/doc/haskell-turtle/html/turtle.haddock
haddock-html:         /usr/share/doc/haskell-turtle/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

