#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 trifecta
version:              2.1.4
visibility:           public
id:                   trifecta-2.1.4-1tfADSQQgJM1pvP6yhkhqX
key:                  trifecta-2.1.4-1tfADSQQgJM1pvP6yhkhqX
license:              BSD-3-Clause
copyright:            Copyright (C) 2010-2017 Edward A. Kmett
maintainer:           Edward A. Kmett <ekmett@gmail.com>
author:               Edward A. Kmett
stability:            experimental
homepage:             http://github.com/ekmett/trifecta/
synopsis:
    A modern parser combinator library with convenient diagnostics

description:
    A modern parser combinator library with slicing and Clang-style colored diagnostics

    For example:

    <<https://i.imgur.com/ZyzUSSn.png>>

    <images/example.png (Local Copy)>

category:             Text, Parsing, Diagnostics, Pretty Printer, Logging
abi:                  0509e27ead0a60ce0be71b998c4e9f6a
exposed:              True
exposed-modules:
    Text.Trifecta Text.Trifecta.Combinators Text.Trifecta.Delta
    Text.Trifecta.Highlight Text.Trifecta.Parser
    Text.Trifecta.Rendering Text.Trifecta.Result Text.Trifecta.Rope
    Text.Trifecta.Tutorial Text.Trifecta.Util.IntervalMap
    Text.Trifecta.Util.It

hidden-modules:
    Text.Trifecta.Util.Combinators Text.Trifecta.Util.Pretty

import-dirs:          /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs:         /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-trifecta
hs-libraries:         HStrifecta-2.1.4-1tfADSQQgJM1pvP6yhkhqX
depends:
    ansi-terminal-1.0.2-2td7snMYnP5JakUmenPhL1 array-0.5.4.0
    base-4.17.2.1 blaze-builder-0.4.4.1-JfDTkwhayxv9gKbvszPHiE
    blaze-html-0.9.2.0-A6Vi4VW5MkkDRUuOYiyz4t
    blaze-markup-0.8.3.0-4OBPTc45d0P9Dl7KWqlGv6 bytestring-0.11.5.3
    charset-0.3.12-6JETPIQNbbbIus40RIh7nM
    comonad-5.0.9-D91In9ouFsZIK56HPieSjK containers-0.6.7
    deepseq-1.4.8.0 fingertree-0.1.6.2-HuIIQftuSxH1m7bMM15jdm
    ghc-prim-0.9.1 hashable-1.4.7.0-LvsgkXc0RJl9ehxeji9DTo
    indexed-traversable-0.1.4-2BJBYQqmGPr8tnVTwezaGL
    lens-5.3.3-6oW8YfnpumtF66FcI0BTsr mtl-2.2.2
    parsers-0.12.12-HtzRWL4JBX8EP2VBspy4KU
    prettyprinter-1.7.1-2fDIWQCpfcFF0VMlKg6ON0
    prettyprinter-ansi-terminal-1.1.3-BFsIH7JRjJdG9vbANpn0JH
    profunctors-5.6.3-EQWfDmX4WapHKCQEOHrrsq
    reducers-3.12.5-8U7LYJAGfGG1Lc7YA1Wprl transformers-0.5.6.2
    unordered-containers-0.2.20.1-LlrDkEbe6ka5Vid8Nf7fMl
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm

haddock-interfaces:   /usr/share/doc/haskell-trifecta/html/trifecta.haddock
haddock-html:         /usr/share/doc/haskell-trifecta/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

