#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 trifecta
version:              2.1.4
visibility:           public
id:                   trifecta-2.1.4-E0smVOv8pTIGY4PrLpqgS8
key:                  trifecta-2.1.4-E0smVOv8pTIGY4PrLpqgS8
license:              BSD-3-Clause
copyright:            Copyright (C) 2010-2017 Edward A. Kmett
maintainer:           Edward A. Kmett <ekmett@gmail.com>
author:               Edward A. Kmett
stability:            experimental
homepage:             http://github.com/ekmett/trifecta/
synopsis:
    A modern parser combinator library with convenient diagnostics

description:
    A modern parser combinator library with slicing and Clang-style colored diagnostics

    For example:

    <<https://i.imgur.com/ZyzUSSn.png>>

    <images/example.png (Local Copy)>

category:             Text, Parsing, Diagnostics, Pretty Printer, Logging
abi:                  05ae212b0076ae8833dbfc511119bf8d
exposed:              True
exposed-modules:
    Text.Trifecta Text.Trifecta.Combinators Text.Trifecta.Delta
    Text.Trifecta.Highlight Text.Trifecta.Parser
    Text.Trifecta.Rendering Text.Trifecta.Result Text.Trifecta.Rope
    Text.Trifecta.Tutorial Text.Trifecta.Util.IntervalMap
    Text.Trifecta.Util.It

hidden-modules:
    Text.Trifecta.Util.Combinators Text.Trifecta.Util.Pretty

import-dirs:          /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs:         /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-trifecta
hs-libraries:         HStrifecta-2.1.4-E0smVOv8pTIGY4PrLpqgS8
depends:
    ansi-terminal-1.0.2-FTkVGNDxEfy5jKOkYDwQmU array-0.5.4.0
    base-4.17.2.1 blaze-builder-0.4.4.1-AKoSlOPVMSdAxdLMijM4A4
    blaze-html-0.9.2.0-JJrFCr8DvKJ7H4iqC8zkVN
    blaze-markup-0.8.3.0-25AsAEbi3IjBxGiBoxEVPW bytestring-0.11.5.3
    charset-0.3.12-63049UCHr372HspUzYUdPu
    comonad-5.0.9-rqciBNhPwFK8CLa0jER9X containers-0.6.7
    deepseq-1.4.8.0 fingertree-0.1.6.2-J4hX5bxq6NrAVsOpYJLAcq
    ghc-prim-0.9.1 hashable-1.4.6.0-AVmZwVVVmv9PclG6VBq0Z
    indexed-traversable-0.1.4-2WKTkNkgrfi8m9oX1GafX8
    lens-5.3.2-Exg2qZYOG9zJ2AlH8CiZ0W mtl-2.2.2
    parsers-0.12.12-6xRexgoIMSzYsEWunI5B5
    prettyprinter-1.7.1-6LAznmhuiuZGYtT9LOkZPA
    prettyprinter-ansi-terminal-1.1.3-1Gx5iZfSbBM4yYdxUe7EWr
    profunctors-5.6.3-KJzm5Hoseu66EgSxkqmvU7
    reducers-3.12.5-6sfSVhhNoNI2i8Skap4P8S transformers-0.5.6.2
    unordered-containers-0.2.20-9npXt9Xm1lq5WoODUfmSXc
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm

haddock-interfaces:   /usr/share/doc/haskell-trifecta/html/trifecta.haddock
haddock-html:         /usr/share/doc/haskell-trifecta/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

