#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 trifecta
version:              2.1.4
visibility:           public
id:                   trifecta-2.1.4-UpWEUJ9UcuG90bKd5Nc1K
key:                  trifecta-2.1.4-UpWEUJ9UcuG90bKd5Nc1K
license:              BSD-3-Clause
copyright:            Copyright (C) 2010-2017 Edward A. Kmett
maintainer:           Edward A. Kmett <ekmett@gmail.com>
author:               Edward A. Kmett
stability:            experimental
homepage:             http://github.com/ekmett/trifecta/
synopsis:
    A modern parser combinator library with convenient diagnostics

description:
    A modern parser combinator library with slicing and Clang-style colored diagnostics

    For example:

    <<https://i.imgur.com/ZyzUSSn.png>>

    <images/example.png (Local Copy)>

category:             Text, Parsing, Diagnostics, Pretty Printer, Logging
abi:                  9da5e12f1f7b25e0f7702b804ee66595
exposed:              True
exposed-modules:
    Text.Trifecta Text.Trifecta.Combinators Text.Trifecta.Delta
    Text.Trifecta.Highlight Text.Trifecta.Parser
    Text.Trifecta.Rendering Text.Trifecta.Result Text.Trifecta.Rope
    Text.Trifecta.Tutorial Text.Trifecta.Util.IntervalMap
    Text.Trifecta.Util.It

hidden-modules:
    Text.Trifecta.Util.Combinators Text.Trifecta.Util.Pretty

import-dirs:          /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs:         /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-trifecta
hs-libraries:         HStrifecta-2.1.4-UpWEUJ9UcuG90bKd5Nc1K
depends:
    ansi-terminal-1.0.2-JNQYc01xThWEgUAi55dqd4 array-0.5.4.0
    base-4.17.2.1 blaze-builder-0.4.4.1-Cau0yAlxVeRBhqZO9aptGP
    blaze-html-0.9.2.0-5UHR2rFfuO85rrjBAwZQF8
    blaze-markup-0.8.3.0-Hf0qvHn7apcGFSqpkksMWB bytestring-0.11.5.3
    charset-0.3.12-BCpPgCvUf0yWOXQ82tdil
    comonad-5.0.9-JEzL9Xb0r14CXPDcPGs7F4 containers-0.6.7
    deepseq-1.4.8.0 fingertree-0.1.6.2-BUoRgPouDSwA5kRYeaTIpE
    ghc-prim-0.9.1 hashable-1.4.5.0-46ofdJt9DgFJv5hpm4ccL9
    indexed-traversable-0.1.4-4tpIJXRq7N27Ef4t7nI4Bs
    lens-5.3.1-Ga5POsfLznm5CIw6bCU9JL mtl-2.2.2
    parsers-0.12.12-ALVsMej7KbTGgXV5in5Vk5
    prettyprinter-1.7.1-FOlixpN0mDDCGef0cfE7Yp
    prettyprinter-ansi-terminal-1.1.3-J2hiX2mZ69Y4bAjq7wYi3i
    profunctors-5.6.3-KOZLO1xtOlQD6lxDMCq9YO
    reducers-3.12.5-8LSjslOpTp6LMS3FskgybW transformers-0.5.6.2
    unordered-containers-0.2.20-9wNMaDmysQKAAHkxxaXhUB
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm

haddock-interfaces:   /usr/share/doc/haskell-trifecta/html/trifecta.haddock
haddock-html:         /usr/share/doc/haskell-trifecta/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

