#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 trifecta
version:              2.1.4
visibility:           public
id:                   trifecta-2.1.4-88WGE0uHjGMIuTMeK3TTpb
key:                  trifecta-2.1.4-88WGE0uHjGMIuTMeK3TTpb
license:              BSD-3-Clause
copyright:            Copyright (C) 2010-2017 Edward A. Kmett
maintainer:           Edward A. Kmett <ekmett@gmail.com>
author:               Edward A. Kmett
stability:            experimental
homepage:             http://github.com/ekmett/trifecta/
synopsis:
    A modern parser combinator library with convenient diagnostics

description:
    A modern parser combinator library with slicing and Clang-style colored diagnostics

    For example:

    <<https://i.imgur.com/ZyzUSSn.png>>

    <images/example.png (Local Copy)>

category:             Text, Parsing, Diagnostics, Pretty Printer, Logging
abi:                  819a5b9ea8b90583cf3ecc35cf208ff3
exposed:              True
exposed-modules:
    Text.Trifecta Text.Trifecta.Combinators Text.Trifecta.Delta
    Text.Trifecta.Highlight Text.Trifecta.Parser
    Text.Trifecta.Rendering Text.Trifecta.Result Text.Trifecta.Rope
    Text.Trifecta.Tutorial Text.Trifecta.Util.IntervalMap
    Text.Trifecta.Util.It

hidden-modules:
    Text.Trifecta.Util.Combinators Text.Trifecta.Util.Pretty

import-dirs:          /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs:         /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-trifecta
hs-libraries:         HStrifecta-2.1.4-88WGE0uHjGMIuTMeK3TTpb
depends:
    ansi-terminal-1.0.2-3mjPvI8uzrIHyOcajwCdFZ array-0.5.4.0
    base-4.17.2.1 blaze-builder-0.4.4.1-GC1i0mzFnQi6MqAUVTXmHq
    blaze-html-0.9.2.0-D6khwrbejGRHAmMP2tGf4Z
    blaze-markup-0.8.3.0-EbqyAfAeVhuGBAyeBNN81V bytestring-0.11.5.3
    charset-0.3.12-LGoKk02G9ut8vqwpqJK8cl
    comonad-5.0.9-DQaTWlknK4SF1nm84xsjc7 containers-0.6.7
    deepseq-1.4.8.0 fingertree-0.1.6.2-6jreaftoePSJjYvaOQW6lX
    ghc-prim-0.9.1 hashable-1.4.5.0-JHGJZlFhSc53NK2NYV614f
    indexed-traversable-0.1.4-1JQoS0W1FKXHtvIno5fsGs
    lens-5.3.1-JQiC8s3SxPvAYItR1bILVE mtl-2.2.2
    parsers-0.12.12-JZdRcBOfwQO9wezFHjpH5F
    prettyprinter-1.7.1-GISel4GwMefHj3FidpnW09
    prettyprinter-ansi-terminal-1.1.3-8UOwX8rKTlo26LHvvVWgFr
    profunctors-5.6.3-Csh75SW7zHf2MqhAiRcu1a
    reducers-3.12.5-CtG8zeG4D5K5mMyjT75FGV transformers-0.5.6.2
    unordered-containers-0.2.20-JDDg5JU7nYP5ffg7vR2UZh
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm

haddock-interfaces:   /usr/share/doc/haskell-trifecta/html/trifecta.haddock
haddock-html:         /usr/share/doc/haskell-trifecta/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

