#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 trifecta
version:              2.1.4
visibility:           public
id:                   trifecta-2.1.4-GjNNvOwlwSF5M78kvkUwUR
key:                  trifecta-2.1.4-GjNNvOwlwSF5M78kvkUwUR
license:              BSD-3-Clause
copyright:            Copyright (C) 2010-2017 Edward A. Kmett
maintainer:           Edward A. Kmett <ekmett@gmail.com>
author:               Edward A. Kmett
stability:            experimental
homepage:             http://github.com/ekmett/trifecta/
synopsis:
    A modern parser combinator library with convenient diagnostics

description:
    A modern parser combinator library with slicing and Clang-style colored diagnostics

    For example:

    <<https://i.imgur.com/ZyzUSSn.png>>

    <images/example.png (Local Copy)>

category:             Text, Parsing, Diagnostics, Pretty Printer, Logging
abi:                  4cf1cd581b95d2577843c246ab40f5ae
exposed:              True
exposed-modules:
    Text.Trifecta Text.Trifecta.Combinators Text.Trifecta.Delta
    Text.Trifecta.Highlight Text.Trifecta.Parser
    Text.Trifecta.Rendering Text.Trifecta.Result Text.Trifecta.Rope
    Text.Trifecta.Tutorial Text.Trifecta.Util.IntervalMap
    Text.Trifecta.Util.It

hidden-modules:
    Text.Trifecta.Util.Combinators Text.Trifecta.Util.Pretty

import-dirs:          /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs:         /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-trifecta
hs-libraries:         HStrifecta-2.1.4-GjNNvOwlwSF5M78kvkUwUR
depends:
    ansi-terminal-1.0.2-FTkVGNDxEfy5jKOkYDwQmU array-0.5.4.0
    base-4.17.2.1 blaze-builder-0.4.4.1-HvGimvnQAK1KewFEc6ubrC
    blaze-html-0.9.2.0-LTAcRvwA4RX5X1Di6KFyT1
    blaze-markup-0.8.3.0-GZv1FLpSykS3DHygI81NMN bytestring-0.11.5.3
    charset-0.3.12-ClIXWbFRE9l2siV2BCZKRA
    comonad-5.0.9-FIUuIsgkoVrC4nmIsOTMUJ containers-0.6.7
    deepseq-1.4.8.0 fingertree-0.1.6.2-GDcHQnf6zwDHzzaBwq2Hc8
    ghc-prim-0.9.1 hashable-1.4.5.0-FhpNKvHQsJeLXuGJFx8piW
    indexed-traversable-0.1.4-SYv5547dJK2gDTDCEMijk
    lens-5.3.1-K6M28KdwyDFInfMmFpBOSR mtl-2.2.2
    parsers-0.12.12-WOoOMW4mfrJS8mGJE0DEQ
    prettyprinter-1.7.1-1kfTx5RMvNJHRpCjVrY3F5
    prettyprinter-ansi-terminal-1.1.3-8ZkLYQp310e9tsa1KLQyqJ
    profunctors-5.6.3-5qUG8FyL9OxHtIbLDB9HjM
    reducers-3.12.5-3YNBeBOoXSDEOvBv1DBqfp transformers-0.5.6.2
    unordered-containers-0.2.20-79maJZZuZDu8bRI1CHuoJG
    utf8-string-1.0.2-EpYvbnx7dwVHTduFVbgaKq

haddock-interfaces:   /usr/share/doc/haskell-trifecta/html/trifecta.haddock
haddock-html:         /usr/share/doc/haskell-trifecta/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

