#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 trifecta
version:              2.1.4
visibility:           public
id:                   trifecta-2.1.4-4FSBiRQyFS0Lx9979cjC7s
key:                  trifecta-2.1.4-4FSBiRQyFS0Lx9979cjC7s
license:              BSD-3-Clause
copyright:            Copyright (C) 2010-2017 Edward A. Kmett
maintainer:           Edward A. Kmett <ekmett@gmail.com>
author:               Edward A. Kmett
stability:            experimental
homepage:             http://github.com/ekmett/trifecta/
synopsis:
    A modern parser combinator library with convenient diagnostics

description:
    A modern parser combinator library with slicing and Clang-style colored diagnostics

    For example:

    <<https://i.imgur.com/ZyzUSSn.png>>

    <images/example.png (Local Copy)>

category:             Text, Parsing, Diagnostics, Pretty Printer, Logging
abi:                  0548580e85590fd804f2738181510677
exposed:              True
exposed-modules:
    Text.Trifecta Text.Trifecta.Combinators Text.Trifecta.Delta
    Text.Trifecta.Highlight Text.Trifecta.Parser
    Text.Trifecta.Rendering Text.Trifecta.Result Text.Trifecta.Rope
    Text.Trifecta.Tutorial Text.Trifecta.Util.IntervalMap
    Text.Trifecta.Util.It

hidden-modules:
    Text.Trifecta.Util.Combinators Text.Trifecta.Util.Pretty

import-dirs:          /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs:         /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-trifecta
hs-libraries:         HStrifecta-2.1.4-4FSBiRQyFS0Lx9979cjC7s
depends:
    ansi-terminal-1.0.2-FTkVGNDxEfy5jKOkYDwQmU array-0.5.4.0
    base-4.17.2.1 blaze-builder-0.4.4.1-Fu0lIXvNfl2GZl8eSsy5LD
    blaze-html-0.9.2.0-97pJC8dBTXf5qZAc9J115X
    blaze-markup-0.8.3.0-FXydca45yHzIHzHIuN3fo7 bytestring-0.11.5.3
    charset-0.3.12-8kGnLxIjbxjEBQKefelDlx
    comonad-5.0.9-DbocoRZxFWPanrrsdFCv7 containers-0.6.7
    deepseq-1.4.8.0 fingertree-0.1.6.2-FvTnL3Gie5xARxh0toHm94
    ghc-prim-0.9.1 hashable-1.4.5.0-tUQ3ISdCwwAzRS3LRBhXn
    indexed-traversable-0.1.4-BQcRr3W4PxWCuaKGpNnbu1
    lens-5.3.1-1aYkBqtQBz47fMfVuyOc0c mtl-2.2.2
    parsers-0.12.12-DdLVyDbM6CM2QXzPnuvkA2
    prettyprinter-1.7.1-2R6NgwfUgVc9iM5YqEeKHX
    prettyprinter-ansi-terminal-1.1.3-18v05W538YvI18BbSi9hYg
    profunctors-5.6.3-HIGdidN5O0T3CUcdAW2Doh
    reducers-3.12.5-B3atp9UgRbc2Gp2l6Jrzmo transformers-0.5.6.2
    unordered-containers-0.2.20-Kt9XOM1GYdv4KClqugAe9a
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm

haddock-interfaces:   /usr/share/doc/haskell-trifecta/html/trifecta.haddock
haddock-html:         /usr/share/doc/haskell-trifecta/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

