#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 trifecta
version:              2.1.4
visibility:           public
id:                   trifecta-2.1.4-5EoOAS6y1AF3Ym3xLWvwjL
key:                  trifecta-2.1.4-5EoOAS6y1AF3Ym3xLWvwjL
license:              BSD-3-Clause
copyright:            Copyright (C) 2010-2017 Edward A. Kmett
maintainer:           Edward A. Kmett <ekmett@gmail.com>
author:               Edward A. Kmett
stability:            experimental
homepage:             http://github.com/ekmett/trifecta/
synopsis:
    A modern parser combinator library with convenient diagnostics

description:
    A modern parser combinator library with slicing and Clang-style colored diagnostics

    For example:

    <<https://i.imgur.com/ZyzUSSn.png>>

    <images/example.png (Local Copy)>

category:             Text, Parsing, Diagnostics, Pretty Printer, Logging
abi:                  97857666f81e5ce2e67de66a8d4cd44a
exposed:              True
exposed-modules:
    Text.Trifecta Text.Trifecta.Combinators Text.Trifecta.Delta
    Text.Trifecta.Highlight Text.Trifecta.Parser
    Text.Trifecta.Rendering Text.Trifecta.Result Text.Trifecta.Rope
    Text.Trifecta.Tutorial Text.Trifecta.Util.IntervalMap
    Text.Trifecta.Util.It

hidden-modules:
    Text.Trifecta.Util.Combinators Text.Trifecta.Util.Pretty

import-dirs:          /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs:         /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-trifecta
hs-libraries:         HStrifecta-2.1.4-5EoOAS6y1AF3Ym3xLWvwjL
depends:
    ansi-terminal-1.0.2-4YFJ3O2CGvXHeK0JwiwGsH array-0.5.4.0
    base-4.17.2.1 blaze-builder-0.4.4-7Kume1TeDrZHW0vCG7GXQa
    blaze-html-0.9.2.0-148ZoU8BzetFm1jSAQ9JQP
    blaze-markup-0.8.3.0-KN3syb3Jq5SH5jCxIlubmm bytestring-0.11.5.3
    charset-0.3.12-GLEwmJglPBcHJf8f7gJEwT
    comonad-5.0.9-Ii5hgdheJL2Zm3d3qSYJo containers-0.6.7
    deepseq-1.4.8.0 fingertree-0.1.6.2-GPbsaxt0rUd1V65BWtnAjG
    ghc-prim-0.9.1 hashable-1.4.5.0-EdCBZmCkEma7WCMhhvMdNf
    indexed-traversable-0.1.4-6I34tNI5leL7QXgWHpiE2g
    lens-5.3.1-GXFgjSkl7U7Fy6s0hRmBiy mtl-2.2.2
    parsers-0.12.12-4rpysLeXm1s48gFZZHmXX6
    prettyprinter-1.7.1-7cHMA52o3usJvB7pVINYaP
    prettyprinter-ansi-terminal-1.1.3-KBc7B4rdJaz2aaKpFfwo1G
    profunctors-5.6.3-JPsyxucHO7GE5uSKcotJO6
    reducers-3.12.5-9IgInaMPtDL3SyZjIpGc3N transformers-0.5.6.2
    unordered-containers-0.2.20-KWLixwBKCEK6ORqUSVo2CW
    utf8-string-1.0.2-3k9iW3aOua82FWJzfAeOkO

haddock-interfaces:   /usr/share/doc/haskell-trifecta/html/trifecta.haddock
haddock-html:         /usr/share/doc/haskell-trifecta/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

