#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 trifecta
version:              2.1.4
visibility:           public
id:                   trifecta-2.1.4-KyZD5pWsDCgAFhgEAzSEb6
key:                  trifecta-2.1.4-KyZD5pWsDCgAFhgEAzSEb6
license:              BSD-3-Clause
copyright:            Copyright (C) 2010-2017 Edward A. Kmett
maintainer:           Edward A. Kmett <ekmett@gmail.com>
author:               Edward A. Kmett
stability:            experimental
homepage:             http://github.com/ekmett/trifecta/
synopsis:
    A modern parser combinator library with convenient diagnostics

description:
    A modern parser combinator library with slicing and Clang-style colored diagnostics

    For example:

    <<https://i.imgur.com/ZyzUSSn.png>>

    <images/example.png (Local Copy)>

category:             Text, Parsing, Diagnostics, Pretty Printer, Logging
abi:                  d9795bbf97fbc740eae8f73e640c63f8
exposed:              True
exposed-modules:
    Text.Trifecta Text.Trifecta.Combinators Text.Trifecta.Delta
    Text.Trifecta.Highlight Text.Trifecta.Parser
    Text.Trifecta.Rendering Text.Trifecta.Result Text.Trifecta.Rope
    Text.Trifecta.Tutorial Text.Trifecta.Util.IntervalMap
    Text.Trifecta.Util.It

hidden-modules:
    Text.Trifecta.Util.Combinators Text.Trifecta.Util.Pretty

import-dirs:          /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs:         /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-trifecta
hs-libraries:         HStrifecta-2.1.4-KyZD5pWsDCgAFhgEAzSEb6
depends:
    ansi-terminal-1.0.2-JhmKbae07oX7bHm2tOBr0F array-0.5.4.0
    base-4.17.2.1 blaze-builder-0.4.4-hpTW57LOkJwByfG1pJQ0
    blaze-html-0.9.2.0-4nZEIuSQm5uJHuPTchkOVN
    blaze-markup-0.8.3.0-1slEV1JTVXCHBVRvUtps3k bytestring-0.11.5.3
    charset-0.3.12-ARXNRxT87CPEk5Ai9ZrdKc
    comonad-5.0.9-2Q42HGQEQ9qERHsHJdWeaK containers-0.6.7
    deepseq-1.4.8.0 fingertree-0.1.6.2-BhhfiWWr3htKZSDYrkNob3
    ghc-prim-0.9.1 hashable-1.4.4.0-ER9qsIVdqB66mmnPytAzi1
    indexed-traversable-0.1.4-GiogE6maAB3IzBkFbVsEUi
    lens-5.3.1-HP4sFfbh3y9B4laWgY1DEm mtl-2.2.2
    parsers-0.12.12-BBCj7Bb5jk88ztzRJGKsZL
    prettyprinter-1.7.1-AWOpW71pl8nIJPFNGLPbj
    prettyprinter-ansi-terminal-1.1.3-1QKmxX9Fvnt1H04g2qTpIN
    profunctors-5.6.3-68oxrF8737XCyiY0Ff7GIY
    reducers-3.12.5-FCCK75S5w6M23qxMqEZ8G3 transformers-0.5.6.2
    unordered-containers-0.2.20-BdnqkwZm9bx6ocoMK9HG74
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm

haddock-interfaces:   /usr/share/doc/haskell-trifecta/html/trifecta.haddock
haddock-html:         /usr/share/doc/haskell-trifecta/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

