#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 trifecta
version:              2.1.4
visibility:           public
id:                   trifecta-2.1.4-CyDpuAaeZiQCzInTPP0H1S
key:                  trifecta-2.1.4-CyDpuAaeZiQCzInTPP0H1S
license:              BSD-3-Clause
copyright:            Copyright (C) 2010-2017 Edward A. Kmett
maintainer:           Edward A. Kmett <ekmett@gmail.com>
author:               Edward A. Kmett
stability:            experimental
homepage:             http://github.com/ekmett/trifecta/
synopsis:
    A modern parser combinator library with convenient diagnostics

description:
    A modern parser combinator library with slicing and Clang-style colored diagnostics

    For example:

    <<https://i.imgur.com/ZyzUSSn.png>>

    <images/example.png (Local Copy)>

category:             Text, Parsing, Diagnostics, Pretty Printer, Logging
abi:                  c805405b95ef0556e65bf83913561af4
exposed:              True
exposed-modules:
    Text.Trifecta Text.Trifecta.Combinators Text.Trifecta.Delta
    Text.Trifecta.Highlight Text.Trifecta.Parser
    Text.Trifecta.Rendering Text.Trifecta.Result Text.Trifecta.Rope
    Text.Trifecta.Tutorial Text.Trifecta.Util.IntervalMap
    Text.Trifecta.Util.It

hidden-modules:
    Text.Trifecta.Util.Combinators Text.Trifecta.Util.Pretty

import-dirs:          /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs:         /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-trifecta
hs-libraries:         HStrifecta-2.1.4-CyDpuAaeZiQCzInTPP0H1S
depends:
    ansi-terminal-1.0.2-5TjUZ7gCnw1CP0OaHljXa6 array-0.5.4.0
    base-4.17.2.1 blaze-builder-0.4.4-J87LvVgADYa5gww986bADm
    blaze-html-0.9.2.0-JcISFZyc75x1w6gURdo9IX
    blaze-markup-0.8.3.0-2DVevyAmVI6DWWGE4G0qSR bytestring-0.11.5.3
    charset-0.3.12-Ayc4VrVhP8g3Wc0AUTRob1
    comonad-5.0.9-E6HUlGQXFnv7OEEIpGkJ7B containers-0.6.7
    deepseq-1.4.8.0 fingertree-0.1.6.2-2mRUunB5uBd7LQhpttXP9P
    ghc-prim-0.9.1 hashable-1.4.4.0-5SoCNaysfySGuPwu0aljBu
    indexed-traversable-0.1.4-32owkfOBjPeHHjn6v5P4Ru
    lens-5.3.1-1UDi0CjALHfJ5iQ7KsOF6H mtl-2.2.2
    parsers-0.12.12-1SQOU8uayYoHImeArjIdoS
    prettyprinter-1.7.1-9QhHPrVd9M8A9sreY2Uj3h
    prettyprinter-ansi-terminal-1.1.3-GWhQt3CM01S5eyYpZ5CutC
    profunctors-5.6.3-54dftqYvfC87HlKhU8lZc
    reducers-3.12.5-AXuRMCrHzGjII6sFoLCNNY transformers-0.5.6.2
    unordered-containers-0.2.20-AeV3HTkHtCc6BQ9fzLSSB8
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm

haddock-interfaces:   /usr/share/doc/haskell-trifecta/html/trifecta.haddock
haddock-html:         /usr/share/doc/haskell-trifecta/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

