#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 trifecta
version:              2.1.4
visibility:           public
id:                   trifecta-2.1.4-LM11POjo10BLLCfkRl4rpE
key:                  trifecta-2.1.4-LM11POjo10BLLCfkRl4rpE
license:              BSD-3-Clause
copyright:            Copyright (C) 2010-2017 Edward A. Kmett
maintainer:           Edward A. Kmett <ekmett@gmail.com>
author:               Edward A. Kmett
stability:            experimental
homepage:             http://github.com/ekmett/trifecta/
synopsis:
    A modern parser combinator library with convenient diagnostics

description:
    A modern parser combinator library with slicing and Clang-style colored diagnostics

    For example:

    <<https://i.imgur.com/ZyzUSSn.png>>

    <images/example.png (Local Copy)>

category:             Text, Parsing, Diagnostics, Pretty Printer, Logging
abi:                  5c3e8899ee00d8ad0cb47519d4577c03
exposed:              True
exposed-modules:
    Text.Trifecta Text.Trifecta.Combinators Text.Trifecta.Delta
    Text.Trifecta.Highlight Text.Trifecta.Parser
    Text.Trifecta.Rendering Text.Trifecta.Result Text.Trifecta.Rope
    Text.Trifecta.Tutorial Text.Trifecta.Util.IntervalMap
    Text.Trifecta.Util.It

hidden-modules:
    Text.Trifecta.Util.Combinators Text.Trifecta.Util.Pretty

import-dirs:          /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs:         /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-trifecta
hs-libraries:         HStrifecta-2.1.4-LM11POjo10BLLCfkRl4rpE
depends:
    ansi-terminal-1.0.2-IimOqSN1qRUFeipP6ofJQ array-0.5.4.0
    base-4.17.2.1 blaze-builder-0.4.4-6Kuq6wnWuSiCILCubQnlxM
    blaze-html-0.9.2.0-Dqz1hSF3Pl41AMAbxwq4Fa
    blaze-markup-0.8.3.0-DSAl5fl5qavBMEF3Zc5OIF bytestring-0.11.5.3
    charset-0.3.12-HCbR2EyIcyHGNcXSJ4sTTW
    comonad-5.0.9-H5cEhJNN7s2AUy4Hfcyvnt containers-0.6.7
    deepseq-1.4.8.0 fingertree-0.1.6.2-KgaN9n2WCbmStKKPC7nlw
    ghc-prim-0.9.1 hashable-1.4.4.0-AmJtI56ndXc1GvGfBNNgwb
    indexed-traversable-0.1.4-HasVynAVtv5C4gt3RjLYOy
    lens-5.3.1-LF4jCoE0w776e2gq32lhyl mtl-2.2.2
    parsers-0.12.12-AbMqtfS88aCIawBScMb3Sn
    prettyprinter-1.7.1-5xgqmGXqgSr2RPa1NTsZyQ
    prettyprinter-ansi-terminal-1.1.3-BMaxYpGY1hqAqhAfKIKQLq
    profunctors-5.6.3-9oHJRkGqT8UJV4EmomAxQT
    reducers-3.12.5-H1jxBNVsv28F10cyWCm0Kr transformers-0.5.6.2
    unordered-containers-0.2.20-3NcLl7S6t7kAuh7l4Ieeoo
    utf8-string-1.0.2-FAQSGuIUGqDKZx6mH04y15

haddock-interfaces:   /usr/share/doc/haskell-trifecta/html/trifecta.haddock
haddock-html:         /usr/share/doc/haskell-trifecta/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

