#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 trifecta
version:              2.1.4
visibility:           public
id:                   trifecta-2.1.4-Et9FsFzalnSkruXVhPsEY
key:                  trifecta-2.1.4-Et9FsFzalnSkruXVhPsEY
license:              BSD-3-Clause
copyright:            Copyright (C) 2010-2017 Edward A. Kmett
maintainer:           Edward A. Kmett <ekmett@gmail.com>
author:               Edward A. Kmett
stability:            experimental
homepage:             http://github.com/ekmett/trifecta/
synopsis:
    A modern parser combinator library with convenient diagnostics

description:
    A modern parser combinator library with slicing and Clang-style colored diagnostics

    For example:

    <<https://i.imgur.com/ZyzUSSn.png>>

    <images/example.png (Local Copy)>

category:             Text, Parsing, Diagnostics, Pretty Printer, Logging
abi:                  f8dd4bbd54b6c1fe1994268709fe5164
exposed:              True
exposed-modules:
    Text.Trifecta Text.Trifecta.Combinators Text.Trifecta.Delta
    Text.Trifecta.Highlight Text.Trifecta.Parser
    Text.Trifecta.Rendering Text.Trifecta.Result Text.Trifecta.Rope
    Text.Trifecta.Tutorial Text.Trifecta.Util.IntervalMap
    Text.Trifecta.Util.It

hidden-modules:
    Text.Trifecta.Util.Combinators Text.Trifecta.Util.Pretty

import-dirs:          /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs:         /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-trifecta
hs-libraries:         HStrifecta-2.1.4-Et9FsFzalnSkruXVhPsEY
depends:
    ansi-terminal-1.0.2-9C7TLPMqFC3EnANnfcyKas array-0.5.4.0
    base-4.17.2.1 blaze-builder-0.4.3-4yy7EUiUNtIb1TX5lPJzq
    blaze-html-0.9.2.0-JOZZ1LRDwMqHxz1pgN67iD
    blaze-markup-0.8.3.0-JCldSIMzkMg8HDcOQdPBOD bytestring-0.11.5.3
    charset-0.3.12-LKROthcGlby8Qt8eoIGYul
    comonad-5.0.9-I2bM6t8c2fB7rHIs9XjGyy containers-0.6.7
    deepseq-1.4.8.0 fingertree-0.1.6.2-KNEOMYCBy9RJydYWYEiZ90
    ghc-prim-0.9.1 hashable-1.4.4.0-85lkkmOSRZHDIzkr9EkKNp
    indexed-traversable-0.1.4-G1Ar9vM2x492EvfRvVfHxJ
    lens-5.3-FNJYFG5nVy3K1UtPWTWg2x mtl-2.2.2
    parsers-0.12.12-5eBAUS44oB72eQOCpZb1Sj
    prettyprinter-1.7.1-Lg6JVLzvNS6KZGjYMe3Z72
    prettyprinter-ansi-terminal-1.1.3-IwF9o6IcilF2GB12Um99ek
    profunctors-5.6.3-Ks2eCIzdKc2gesAHQYhNk
    reducers-3.12.5-GO6hoQSPWwa5mGOCOgH0rJ transformers-0.5.6.2
    unordered-containers-0.2.20-Cw2Ec4BgC4sInKE4e5RLSk
    utf8-string-1.0.2-FAQSGuIUGqDKZx6mH04y15

haddock-interfaces:   /usr/share/doc/haskell-trifecta/html/trifecta.haddock
haddock-html:         /usr/share/doc/haskell-trifecta/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

