#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 trifecta
version:              2.1.4
visibility:           public
id:                   trifecta-2.1.4-1yUHVjpbgzf7O3qAGlORVt
key:                  trifecta-2.1.4-1yUHVjpbgzf7O3qAGlORVt
license:              BSD-3-Clause
copyright:            Copyright (C) 2010-2017 Edward A. Kmett
maintainer:           Edward A. Kmett <ekmett@gmail.com>
author:               Edward A. Kmett
stability:            experimental
homepage:             http://github.com/ekmett/trifecta/
synopsis:
    A modern parser combinator library with convenient diagnostics

description:
    A modern parser combinator library with slicing and Clang-style colored diagnostics

    For example:

    <<https://i.imgur.com/ZyzUSSn.png>>

    <images/example.png (Local Copy)>

category:             Text, Parsing, Diagnostics, Pretty Printer, Logging
abi:                  0804ffeadbf25dbd99dba07615493bd9
exposed:              True
exposed-modules:
    Text.Trifecta Text.Trifecta.Combinators Text.Trifecta.Delta
    Text.Trifecta.Highlight Text.Trifecta.Parser
    Text.Trifecta.Rendering Text.Trifecta.Result Text.Trifecta.Rope
    Text.Trifecta.Tutorial Text.Trifecta.Util.IntervalMap
    Text.Trifecta.Util.It

hidden-modules:
    Text.Trifecta.Util.Combinators Text.Trifecta.Util.Pretty

import-dirs:          /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs:         /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-trifecta
hs-libraries:         HStrifecta-2.1.4-1yUHVjpbgzf7O3qAGlORVt
depends:
    ansi-terminal-1.0.2-BmYwE3CMMeiHUDLKLgejP7 array-0.5.4.0
    base-4.17.2.1 blaze-builder-0.4.3-CCGWpBjxAylCkXXKn5PO27
    blaze-html-0.9.2.0-9ouvNI0LGvR8T2YDANh957
    blaze-markup-0.8.3.0-H4QAcgAuzx9AWvBQPdzmLl bytestring-0.11.5.3
    charset-0.3.12-1Cxyu4HD7jH89iWEmEbQZ8
    comonad-5.0.9-2Mq6oKk03T91yHRIzU3nPf containers-0.6.7
    deepseq-1.4.8.0 fingertree-0.1.6.2-AAkya2mig1Z6rI2PO8JTfr
    ghc-prim-0.9.1 hashable-1.4.4.0-C1fFIG7AZLC7j0jzLm97Uw
    indexed-traversable-0.1.4-2T176InstcMqAaY6WCojl
    lens-5.3-6U8rnlrA3UzGhSFoVj5hOc mtl-2.2.2
    parsers-0.12.12-DErfaxT6lwyB7JqmqUud4T
    prettyprinter-1.7.1-H0iQpJbBZ6k9IFy5REj5dh
    prettyprinter-ansi-terminal-1.1.3-FhScSTfQH45372MjCmeGhc
    profunctors-5.6.3-8FNppvPYojn1YMtMW6wR6o
    reducers-3.12.5-JKLtQNWWIRV4ZTJcA4Fu1f transformers-0.5.6.2
    unordered-containers-0.2.20-obNV32ZSreHxgWRz6JrKP
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm

haddock-interfaces:   /usr/share/doc/haskell-trifecta/html/trifecta.haddock
haddock-html:         /usr/share/doc/haskell-trifecta/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

