#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 trifecta
version:              2.1.4
visibility:           public
id:                   trifecta-2.1.4-JIGYc9T5DY42KXvcUtSQSP
key:                  trifecta-2.1.4-JIGYc9T5DY42KXvcUtSQSP
license:              BSD-3-Clause
copyright:            Copyright (C) 2010-2017 Edward A. Kmett
maintainer:           Edward A. Kmett <ekmett@gmail.com>
author:               Edward A. Kmett
stability:            experimental
homepage:             http://github.com/ekmett/trifecta/
synopsis:
    A modern parser combinator library with convenient diagnostics

description:
    A modern parser combinator library with slicing and Clang-style colored diagnostics

    For example:

    <<https://i.imgur.com/ZyzUSSn.png>>

    <images/example.png (Local Copy)>

category:             Text, Parsing, Diagnostics, Pretty Printer, Logging
abi:                  045ed205c8879aa9cd49f578102fae86
exposed:              True
exposed-modules:
    Text.Trifecta Text.Trifecta.Combinators Text.Trifecta.Delta
    Text.Trifecta.Highlight Text.Trifecta.Parser
    Text.Trifecta.Rendering Text.Trifecta.Result Text.Trifecta.Rope
    Text.Trifecta.Tutorial Text.Trifecta.Util.IntervalMap
    Text.Trifecta.Util.It

hidden-modules:
    Text.Trifecta.Util.Combinators Text.Trifecta.Util.Pretty

import-dirs:          /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs:         /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-trifecta
hs-libraries:         HStrifecta-2.1.4-JIGYc9T5DY42KXvcUtSQSP
depends:
    ansi-terminal-1.0.2-HPtVnAU9d4e2sgA8soPDqO array-0.5.4.0
    base-4.17.2.1 blaze-builder-0.4.3-9mr2QS4Ac5jKPZdkUQKEwx
    blaze-html-0.9.2.0-HIsrFdX7DIkeeC0HU7u92
    blaze-markup-0.8.3.0-5mq9ryWS59iKdKRZ7SDBZd bytestring-0.11.5.3
    charset-0.3.12-4Fa9LOCl6XpDsW0O0Z3S3n
    comonad-5.0.9-97Fbz0gGzNIElpfJT6KH41 containers-0.6.7
    deepseq-1.4.8.0 fingertree-0.1.6.2-AdScGEVrSYp8uv6ysL3HOn
    ghc-prim-0.9.1 hashable-1.4.4.0-HCL6HYi7vZb6weAXUagHtJ
    indexed-traversable-0.1.4-GkGrJgji2sS1heT6R1yu0
    lens-5.3-pl18ecYYzn8sW5PtrryAE mtl-2.2.2
    parsers-0.12.12-7PEU0i9OZOhIj5xUnqMhs
    prettyprinter-1.7.1-CblNKNR1eKT9nxUoBiyJi9
    prettyprinter-ansi-terminal-1.1.3-BetCIThzEOW7GW5IXaiUDk
    profunctors-5.6.3-9pKr3F9zUDFI44dXqzMZB2
    reducers-3.12.5-AZ4LZ2AiAw6ABQ7DE1c6a5 transformers-0.5.6.2
    unordered-containers-0.2.20-FFF0GulGLFtAHq6N1Lkm0s
    utf8-string-1.0.2-LQzUWC2hIN17FDKHsw4I2c

haddock-interfaces:   /usr/share/doc/haskell-trifecta/html/trifecta.haddock
haddock-html:         /usr/share/doc/haskell-trifecta/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

