#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 trifecta
version:              2.1.4
visibility:           public
id:                   trifecta-2.1.4-KRSO01x8lNR9RtVWX3eNmq
key:                  trifecta-2.1.4-KRSO01x8lNR9RtVWX3eNmq
license:              BSD-3-Clause
copyright:            Copyright (C) 2010-2017 Edward A. Kmett
maintainer:           Edward A. Kmett <ekmett@gmail.com>
author:               Edward A. Kmett
stability:            experimental
homepage:             http://github.com/ekmett/trifecta/
synopsis:
    A modern parser combinator library with convenient diagnostics

description:
    A modern parser combinator library with slicing and Clang-style colored diagnostics

    For example:

    <<https://i.imgur.com/ZyzUSSn.png>>

    <images/example.png (Local Copy)>

category:             Text, Parsing, Diagnostics, Pretty Printer, Logging
abi:                  c44909abdba9ad686991b22674bb00a1
exposed:              True
exposed-modules:
    Text.Trifecta Text.Trifecta.Combinators Text.Trifecta.Delta
    Text.Trifecta.Highlight Text.Trifecta.Parser
    Text.Trifecta.Rendering Text.Trifecta.Result Text.Trifecta.Rope
    Text.Trifecta.Tutorial Text.Trifecta.Util.IntervalMap
    Text.Trifecta.Util.It

hidden-modules:
    Text.Trifecta.Util.Combinators Text.Trifecta.Util.Pretty

import-dirs:          /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs:         /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-trifecta
hs-libraries:         HStrifecta-2.1.4-KRSO01x8lNR9RtVWX3eNmq
depends:
    ansi-terminal-1.0.2-4F37L3ko1KQ1hALBi4f5f0 array-0.5.4.0
    base-4.17.2.1 blaze-builder-0.4.3-HXodF8PiFiTI0hprQuztF4
    blaze-html-0.9.2.0-3YZTlMAnllRFVmykcDevNv
    blaze-markup-0.8.3.0-LoFuvEUpMWsE3h8IrKFaX0 bytestring-0.11.5.3
    charset-0.3.12-613bZ2LYj7CGEZ8s9CAcoZ
    comonad-5.0.9-hxJyyI2ewp68TZePLjVku containers-0.6.7
    deepseq-1.4.8.0 fingertree-0.1.6.2-GU0QCwIBb692ip9Rr3T1iQ
    ghc-prim-0.9.1 hashable-1.4.4.0-4IkOt4KzeSSA3Xc4u5PLaT
    indexed-traversable-0.1.4-FpAcbJlkQDVBCnOnkgXYhG
    lens-5.3-2T63PvFtwZXqnWv0im5sF mtl-2.2.2
    parsers-0.12.12-LCg4ZRhZS13DgYdSbllTWN
    prettyprinter-1.7.1-G4E3PI2BTIHFT7NfmJKOqD
    prettyprinter-ansi-terminal-1.1.3-FHReNHhiJ9k22dC6VcAYKN
    profunctors-5.6.3-4WpHBsS0I4A3CkrD0G43oU
    reducers-3.12.5-C4YNUArPLGm44UllnBBluz transformers-0.5.6.2
    unordered-containers-0.2.20-A2tjqfQXDXnFd3Ae9FP0C3
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm

haddock-interfaces:   /usr/share/doc/haskell-trifecta/html/trifecta.haddock
haddock-html:         /usr/share/doc/haskell-trifecta/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

