#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 trifecta
version:              2.1.4
visibility:           public
id:                   trifecta-2.1.4-6mlGLbmLjzkEM92sD572Bf
key:                  trifecta-2.1.4-6mlGLbmLjzkEM92sD572Bf
license:              BSD-3-Clause
copyright:            Copyright (C) 2010-2017 Edward A. Kmett
maintainer:           Edward A. Kmett <ekmett@gmail.com>
author:               Edward A. Kmett
stability:            experimental
homepage:             http://github.com/ekmett/trifecta/
synopsis:
    A modern parser combinator library with convenient diagnostics

description:
    A modern parser combinator library with slicing and Clang-style colored diagnostics

    For example:

    <<https://i.imgur.com/ZyzUSSn.png>>

    <images/example.png (Local Copy)>

category:             Text, Parsing, Diagnostics, Pretty Printer, Logging
abi:                  f19baae0b73458f367e51000826dcb32
exposed:              True
exposed-modules:
    Text.Trifecta Text.Trifecta.Combinators Text.Trifecta.Delta
    Text.Trifecta.Highlight Text.Trifecta.Parser
    Text.Trifecta.Rendering Text.Trifecta.Result Text.Trifecta.Rope
    Text.Trifecta.Tutorial Text.Trifecta.Util.IntervalMap
    Text.Trifecta.Util.It

hidden-modules:
    Text.Trifecta.Util.Combinators Text.Trifecta.Util.Pretty

import-dirs:          /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs:         /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-trifecta
hs-libraries:         HStrifecta-2.1.4-6mlGLbmLjzkEM92sD572Bf
depends:
    ansi-terminal-1.0.2-EudAPB7rRCyDJBI0UXDeTd array-0.5.4.0
    base-4.17.2.1 blaze-builder-0.4.3-KajDOuS86PHBEcDCbLATP7
    blaze-html-0.9.2.0-Af5P3A2URAm8PEOIhy6b3k
    blaze-markup-0.8.3.0-Alr6JP17MQvDFN7aUk8LfK bytestring-0.11.5.3
    charset-0.3.12-91ANuAs7M4S4w6qiq0xjgV
    comonad-5.0.9-13F92n1w389BPKV3mAQNFl containers-0.6.7
    deepseq-1.4.8.0 fingertree-0.1.6.2-C0NZyvIP0KB9daiOmA8Owi
    ghc-prim-0.9.1 hashable-1.4.4.0-JPfSbBrFTKBgQKoWbpACz
    indexed-traversable-0.1.4-daDHdCedQd5Buv5VkdtT9
    lens-5.3-L5hp9JbMaZ3ARz3g7EupwI mtl-2.2.2
    parsers-0.12.12-H8uFmkVMbmeEuDJmRTcBZ4
    prettyprinter-1.7.1-KiZcPWXJVNZ6oHVA0qVcfd
    prettyprinter-ansi-terminal-1.1.3-1ng9uWt2kiaHr5skgX5vwF
    profunctors-5.6.3-GArqOHJv0awImS3tNH5SQb
    reducers-3.12.5-EY8UhF21s6JLR8IIgIW6VH transformers-0.5.6.2
    unordered-containers-0.2.20-DaOkK38PYRa9pF7ZwbG4ZB
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm

haddock-interfaces:   /usr/share/doc/haskell-trifecta/html/trifecta.haddock
haddock-html:         /usr/share/doc/haskell-trifecta/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

