#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 trifecta
version:              2.1.4
visibility:           public
id:                   trifecta-2.1.4-11iiy261myt1opPQJtcmFE
key:                  trifecta-2.1.4-11iiy261myt1opPQJtcmFE
license:              BSD-3-Clause
copyright:            Copyright (C) 2010-2017 Edward A. Kmett
maintainer:           Edward A. Kmett <ekmett@gmail.com>
author:               Edward A. Kmett
stability:            experimental
homepage:             http://github.com/ekmett/trifecta/
synopsis:
    A modern parser combinator library with convenient diagnostics

description:
    A modern parser combinator library with slicing and Clang-style colored diagnostics

    For example:

    <<https://i.imgur.com/ZyzUSSn.png>>

    <images/example.png (Local Copy)>

category:             Text, Parsing, Diagnostics, Pretty Printer, Logging
abi:                  777c9217cab9850e33a4ba5a0521a017
exposed:              True
exposed-modules:
    Text.Trifecta Text.Trifecta.Combinators Text.Trifecta.Delta
    Text.Trifecta.Highlight Text.Trifecta.Parser
    Text.Trifecta.Rendering Text.Trifecta.Result Text.Trifecta.Rope
    Text.Trifecta.Tutorial Text.Trifecta.Util.IntervalMap
    Text.Trifecta.Util.It

hidden-modules:
    Text.Trifecta.Util.Combinators Text.Trifecta.Util.Pretty

import-dirs:          /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs:         /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-trifecta
hs-libraries:         HStrifecta-2.1.4-11iiy261myt1opPQJtcmFE
depends:
    ansi-terminal-1.0.2-7iJd05aKggE3LiIfKfS0OR array-0.5.4.0
    base-4.17.2.1 blaze-builder-0.4.3-28SzfArXjkvErNNh4sXQKm
    blaze-html-0.9.2.0-1o80EWHMpY0BuGRIuRg92O
    blaze-markup-0.8.3.0-4zzXpVLD4d23Y4oP0TA1oB bytestring-0.11.5.3
    charset-0.3.12-4GOy3AbNO215Ia2dL1tioj
    comonad-5.0.9-DPxzWzHLu9J4KqNMUV0jwa containers-0.6.7
    deepseq-1.4.8.0 fingertree-0.1.6.2-FhvoxmkALwe6jyAUSbOG80
    ghc-prim-0.9.1 hashable-1.4.4.0-HcIU0jNirb1KY01FJoO6uU
    indexed-traversable-0.1.4-KlT0Wrn9TQiIszwKvODAZp
    lens-5.3-J85SWdrxBiwGIuYlY8I9aG mtl-2.2.2
    parsers-0.12.12-Fiw27Lc4EhH6mrPl22nuKX
    prettyprinter-1.7.1-LPaoyWKSQT7KS513LTmQrZ
    prettyprinter-ansi-terminal-1.1.3-2hI4QKbGqc5CZyGYrHlhah
    profunctors-5.6.3-HEYfd0vfOhiGNfrAjjmycl
    reducers-3.12.5-DzIqY9e4nkMBmk8M6f7C5G transformers-0.5.6.2
    unordered-containers-0.2.20-BooESfmG3DbHMU6mBvbzIL
    utf8-string-1.0.2-EQXJBdOxi5qEemJFLwYYhw

haddock-interfaces:   /usr/share/doc/haskell-trifecta/html/trifecta.haddock
haddock-html:         /usr/share/doc/haskell-trifecta/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

