#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 tree-diff
version:              0.3.0.1
visibility:           public
id:                   tree-diff-0.3.0.1-zF7QV19RyYCXGfHhXqzg7
key:                  tree-diff-0.3.0.1-zF7QV19RyYCXGfHhXqzg7
license:              GPL-2.0-or-later
copyright:            (c) 2017-2021 Oleg Grenrus
maintainer:           Oleg.Grenrus <oleg.grenrus@iki.fi>
author:               Oleg Grenrus <oleg.grenrus@iki.fi>
homepage:             https://github.com/phadej/tree-diff
synopsis:             Diffing of (expression) trees.
description:
    Common diff algorithm works on list structures:

    @
    diff :: Eq a => [a] -> [a] -> [Edit a]
    @

    This package works on trees.

    @
    treeDiff :: Eq a => Tree a -> Tree a -> Edit (EditTree a)
    @

    This package also provides a way to diff arbitrary ADTs,
    using @Generics@-derivable helpers.

    This package differs from <http://hackage.haskell.org/package/gdiff gdiff>,
    in a two ways: @tree-diff@ doesn'\''t have patch function,
    and the "edit-script" is a tree itself, which is useful for pretty-printing.

    @
    >>> prettyEditExpr $ ediff (Foo 42 [True, False] "old") (Foo 42 [False, False, True] "new")
    Foo
    \  {fooBool = [-True, +False, False, +True],
    \   fooInt = 42,
    \   fooString = -"old" +"new"}
    @

category:             Data, Testing
abi:                  3c9be6c8b5d90b607fade85b2076c97c
exposed:              True
exposed-modules:
    Data.TreeDiff Data.TreeDiff.Class Data.TreeDiff.Expr
    Data.TreeDiff.Golden Data.TreeDiff.List Data.TreeDiff.OMap
    Data.TreeDiff.Parser Data.TreeDiff.Pretty Data.TreeDiff.QuickCheck
    Data.TreeDiff.Tree

import-dirs:          /usr/lib/ghc-9.4.8/site-local/tree-diff-0.3.0.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/tree-diff-0.3.0.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/tree-diff-0.3.0.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-tree-diff
hs-libraries:         HStree-diff-0.3.0.1-zF7QV19RyYCXGfHhXqzg7
depends:
    QuickCheck-2.15.0.1-Ev8f4YvWcjR3aGAT6KgUIz
    aeson-2.1.2.1-IUt8ms8F4mK1p5ihNOaPfT
    ansi-terminal-1.0.2-5rU4pkSh0boE3ReNmRQ6hH
    ansi-wl-pprint-1.0.2-8xD4vxag6lc7MdlFkU6lXa base-4.17.2.1
    base-compat-0.14.0-D6ySGt5shRqHRPQXrHl9Oo bytestring-0.11.5.3
    containers-0.6.7 deepseq-1.4.8.0
    hashable-1.4.6.0-2vEivDIcaMF9mfkC7wRjoU parsec-3.1.16.1
    parsers-0.12.12-Fj33ZbpVKfRD9IdEYNnRB5 pretty-1.1.3.6
    primitive-0.9.1.0-GwVG9kES81dKICwS7ZHr7
    scientific-0.3.8.0-Csy6naPBtz6IxA0BF8lmor
    semialign-1.3.1-2HrjM3xVHz02Uc0MmBCt5K
    strict-0.5-3bPe8vCdJwOA7IBkqoWMsB
    tagged-0.8.9-KMS3sfDasKWItFZcxfaN6C text-2.0.2
    these-1.2.1-4VQanxuOgE02PoJiSIJOLj time-1.12.2
    unordered-containers-0.2.20-8z8yrOH3Dwd8Gc78vZRE2k
    uuid-types-1.0.6-IMLQEcXeMcbHpik3Tf72BT
    vector-0.13.2.0-C8nzmtHpFSiD5klMFr8FFK

haddock-interfaces:   /usr/share/doc/haskell-tree-diff/html/tree-diff.haddock
haddock-html:         /usr/share/doc/haskell-tree-diff/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

