#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 tree-diff
version:              0.3.0.1
visibility:           public
id:                   tree-diff-0.3.0.1-8z532pZBHys57SmRIwN7jU
key:                  tree-diff-0.3.0.1-8z532pZBHys57SmRIwN7jU
license:              GPL-2.0-or-later
copyright:            (c) 2017-2021 Oleg Grenrus
maintainer:           Oleg.Grenrus <oleg.grenrus@iki.fi>
author:               Oleg Grenrus <oleg.grenrus@iki.fi>
homepage:             https://github.com/phadej/tree-diff
synopsis:             Diffing of (expression) trees.
description:
    Common diff algorithm works on list structures:

    @
    diff :: Eq a => [a] -> [a] -> [Edit a]
    @

    This package works on trees.

    @
    treeDiff :: Eq a => Tree a -> Tree a -> Edit (EditTree a)
    @

    This package also provides a way to diff arbitrary ADTs,
    using @Generics@-derivable helpers.

    This package differs from <http://hackage.haskell.org/package/gdiff gdiff>,
    in a two ways: @tree-diff@ doesn'\''t have patch function,
    and the "edit-script" is a tree itself, which is useful for pretty-printing.

    @
    >>> prettyEditExpr $ ediff (Foo 42 [True, False] "old") (Foo 42 [False, False, True] "new")
    Foo
    \  {fooBool = [-True, +False, False, +True],
    \   fooInt = 42,
    \   fooString = -"old" +"new"}
    @

category:             Data, Testing
abi:                  0c2f767c52e8c83e250d1f92ed5c71e5
exposed:              True
exposed-modules:
    Data.TreeDiff Data.TreeDiff.Class Data.TreeDiff.Expr
    Data.TreeDiff.Golden Data.TreeDiff.List Data.TreeDiff.OMap
    Data.TreeDiff.Parser Data.TreeDiff.Pretty Data.TreeDiff.QuickCheck
    Data.TreeDiff.Tree

import-dirs:          /usr/lib/ghc-9.4.8/site-local/tree-diff-0.3.0.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/tree-diff-0.3.0.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/tree-diff-0.3.0.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-tree-diff
hs-libraries:         HStree-diff-0.3.0.1-8z532pZBHys57SmRIwN7jU
depends:
    QuickCheck-2.15.0.1-I0djFeIgNIwKhHwbhHCf4p
    aeson-2.1.2.1-CM1TyKExMgH6p2KQqrdDHD
    ansi-terminal-1.0.2-7enoCfAnx2SGJDVGgMW6rt
    ansi-wl-pprint-1.0.2-Ji0N6hxkUfx6jAcvGV9LRj base-4.17.2.1
    base-compat-0.13.1-8jgXJjtFto7AX0ry1QXDcA bytestring-0.11.5.3
    containers-0.6.7 deepseq-1.4.8.0
    hashable-1.4.5.0-DrXzgEMDRcV8gNOMGO5wPZ parsec-3.1.16.1
    parsers-0.12.12-4Avmhnq4mpdAan7s2Mf6Hi pretty-1.1.3.6
    primitive-0.9.1.0-Jxt7FQpUmq1Ffbc4VwJGN5
    scientific-0.3.8.0-BCRNugtxiDS8UMOiZ0ZEsF
    semialign-1.3.1-38xztmCDDENL24lnVzyiHk
    strict-0.5-JrjUHjXQtoFD6aDl0wc8J9
    tagged-0.8.9-KMS3sfDasKWItFZcxfaN6C text-2.0.2
    these-1.2.1-7h2BB8zQYzzI0zs7FKrs1b time-1.12.2
    unordered-containers-0.2.20-FLM1pZb3BI5FpyNo5sVXNv
    uuid-types-1.0.6-4FBWy54GmK8HdU0HTDUBUB
    vector-0.13.2.0-LmFi28PTaN7DJJszRwFTiC

haddock-interfaces:   /usr/share/doc/haskell-tree-diff/html/tree-diff.haddock
haddock-html:         /usr/share/doc/haskell-tree-diff/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

