#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 tree-diff
version:              0.3.0.1
visibility:           public
id:                   tree-diff-0.3.0.1-1S7d41ASmAT5ZqqK2TJpTX
key:                  tree-diff-0.3.0.1-1S7d41ASmAT5ZqqK2TJpTX
license:              GPL-2.0-or-later
copyright:            (c) 2017-2021 Oleg Grenrus
maintainer:           Oleg.Grenrus <oleg.grenrus@iki.fi>
author:               Oleg Grenrus <oleg.grenrus@iki.fi>
homepage:             https://github.com/phadej/tree-diff
synopsis:             Diffing of (expression) trees.
description:
    Common diff algorithm works on list structures:

    @
    diff :: Eq a => [a] -> [a] -> [Edit a]
    @

    This package works on trees.

    @
    treeDiff :: Eq a => Tree a -> Tree a -> Edit (EditTree a)
    @

    This package also provides a way to diff arbitrary ADTs,
    using @Generics@-derivable helpers.

    This package differs from <http://hackage.haskell.org/package/gdiff gdiff>,
    in a two ways: @tree-diff@ doesn'\''t have patch function,
    and the "edit-script" is a tree itself, which is useful for pretty-printing.

    @
    >>> prettyEditExpr $ ediff (Foo 42 [True, False] "old") (Foo 42 [False, False, True] "new")
    Foo
    \  {fooBool = [-True, +False, False, +True],
    \   fooInt = 42,
    \   fooString = -"old" +"new"}
    @

category:             Data, Testing
abi:                  c9d33e522b01d29e770a821a73595b00
exposed:              True
exposed-modules:
    Data.TreeDiff Data.TreeDiff.Class Data.TreeDiff.Expr
    Data.TreeDiff.Golden Data.TreeDiff.List Data.TreeDiff.OMap
    Data.TreeDiff.Parser Data.TreeDiff.Pretty Data.TreeDiff.QuickCheck
    Data.TreeDiff.Tree

import-dirs:          /usr/lib/ghc-9.4.8/site-local/tree-diff-0.3.0.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/tree-diff-0.3.0.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/tree-diff-0.3.0.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-tree-diff
hs-libraries:         HStree-diff-0.3.0.1-1S7d41ASmAT5ZqqK2TJpTX
depends:
    QuickCheck-2.14.3-ByUzmICu9MK1GnGhfACscM
    aeson-2.1.2.1-2383fjET7FWJSHJW4VQuW
    ansi-terminal-1.0.2-5TjUZ7gCnw1CP0OaHljXa6
    ansi-wl-pprint-1.0.2-KYJF8gcjmoPBCfOuMfe62c base-4.17.2.1
    base-compat-0.13.0-4bY7VGgUDQwFnN0OMsXbDp bytestring-0.11.5.3
    containers-0.6.7 deepseq-1.4.8.0
    hashable-1.4.4.0-5SoCNaysfySGuPwu0aljBu parsec-3.1.16.1
    parsers-0.12.12-1SQOU8uayYoHImeArjIdoS pretty-1.1.3.6
    primitive-0.9.1.0-3MsYNTRfRHtDQ9eN2n6le5
    scientific-0.3.8.0-IYXDhI1DsbO4omE9hYw4Ya
    semialign-1.3.1-Dk9aD5bDstBLqIZG95oLbr
    strict-0.5-JuX1OQZNJfQIX8wtgKteiI
    tagged-0.8.9-KMS3sfDasKWItFZcxfaN6C text-2.0.2
    these-1.2.1-1NEeGX2jWKNBNb0xrVz49O time-1.12.2
    unordered-containers-0.2.20-AeV3HTkHtCc6BQ9fzLSSB8
    uuid-types-1.0.6-13HT31uDSYFEjUCN0NKGBT
    vector-0.13.2.0-52P7Ozt5w3I6hi4WvheJB9

haddock-interfaces:   /usr/share/doc/haskell-tree-diff/html/tree-diff.haddock
haddock-html:         /usr/share/doc/haskell-tree-diff/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

