#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 tree-diff
version:              0.3.0.1
visibility:           public
id:                   tree-diff-0.3.0.1-7iOihcXGHTIFaHJpLfZ0hM
key:                  tree-diff-0.3.0.1-7iOihcXGHTIFaHJpLfZ0hM
license:              GPL-2.0-or-later
copyright:            (c) 2017-2021 Oleg Grenrus
maintainer:           Oleg.Grenrus <oleg.grenrus@iki.fi>
author:               Oleg Grenrus <oleg.grenrus@iki.fi>
homepage:             https://github.com/phadej/tree-diff
synopsis:             Diffing of (expression) trees.
description:
    Common diff algorithm works on list structures:

    @
    diff :: Eq a => [a] -> [a] -> [Edit a]
    @

    This package works on trees.

    @
    treeDiff :: Eq a => Tree a -> Tree a -> Edit (EditTree a)
    @

    This package also provides a way to diff arbitrary ADTs,
    using @Generics@-derivable helpers.

    This package differs from <http://hackage.haskell.org/package/gdiff gdiff>,
    in a two ways: @tree-diff@ doesn'\''t have patch function,
    and the "edit-script" is a tree itself, which is useful for pretty-printing.

    @
    >>> prettyEditExpr $ ediff (Foo 42 [True, False] "old") (Foo 42 [False, False, True] "new")
    Foo
    \  {fooBool = [-True, +False, False, +True],
    \   fooInt = 42,
    \   fooString = -"old" +"new"}
    @

category:             Data, Testing
abi:                  c3d75ee8d69a95652208e91ef2b4f63b
exposed:              True
exposed-modules:
    Data.TreeDiff Data.TreeDiff.Class Data.TreeDiff.Expr
    Data.TreeDiff.Golden Data.TreeDiff.List Data.TreeDiff.OMap
    Data.TreeDiff.Parser Data.TreeDiff.Pretty Data.TreeDiff.QuickCheck
    Data.TreeDiff.Tree

import-dirs:          /usr/lib/ghc-9.4.8/site-local/tree-diff-0.3.0.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/tree-diff-0.3.0.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/tree-diff-0.3.0.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-tree-diff
hs-libraries:         HStree-diff-0.3.0.1-7iOihcXGHTIFaHJpLfZ0hM
depends:
    QuickCheck-2.14.3-2A88Zj501Le65aGYfSmEOh
    aeson-2.1.2.1-KxhFBZPQYXiG3TO3nhA4Kq
    ansi-terminal-1.0.2-FdTURvxQW9QL5jnf7uGcXG
    ansi-wl-pprint-1.0.2-1hYwdX8TdyJ65RWARrQczz base-4.17.2.1
    base-compat-0.13.0-4bY7VGgUDQwFnN0OMsXbDp bytestring-0.11.5.3
    containers-0.6.7 deepseq-1.4.8.0
    hashable-1.4.4.0-E3AlBtIk95ULiiCgr6U6fg parsec-3.1.16.1
    parsers-0.12.12-KyiHgX4kJzr5DprIUqsnzC pretty-1.1.3.6
    primitive-0.9.1.0-GChnkqMWBe7B15Z0K3IGlf
    scientific-0.3.8.0-4yENNWrElASJBAecoCEn1P
    semialign-1.3.1-3AxrcajVDOBfZvePVgNst
    strict-0.5-46jVfsuyrjSG2FFgNQzXgL
    tagged-0.8.9-KMS3sfDasKWItFZcxfaN6C text-2.0.2
    these-1.2.1-Hs5bRX0rW0e8jZpdKnQOB4 time-1.12.2
    unordered-containers-0.2.20-Ee1qJYwM3Cx9FXWFU8Ujy3
    uuid-types-1.0.6-5D0TlcL4fcn3sA7xCjp2Lw
    vector-0.13.2.0-cop25r7TnE5vewvd3oOyK

haddock-interfaces:   /usr/share/doc/haskell-tree-diff/html/tree-diff.haddock
haddock-html:         /usr/share/doc/haskell-tree-diff/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

