#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 tree-diff
version:              0.3.0.1
visibility:           public
id:                   tree-diff-0.3.0.1-GNA3R5DCVKhFnGhPCw0Vd3
key:                  tree-diff-0.3.0.1-GNA3R5DCVKhFnGhPCw0Vd3
license:              GPL-2.0-or-later
copyright:            (c) 2017-2021 Oleg Grenrus
maintainer:           Oleg.Grenrus <oleg.grenrus@iki.fi>
author:               Oleg Grenrus <oleg.grenrus@iki.fi>
homepage:             https://github.com/phadej/tree-diff
synopsis:             Diffing of (expression) trees.
description:
    Common diff algorithm works on list structures:

    @
    diff :: Eq a => [a] -> [a] -> [Edit a]
    @

    This package works on trees.

    @
    treeDiff :: Eq a => Tree a -> Tree a -> Edit (EditTree a)
    @

    This package also provides a way to diff arbitrary ADTs,
    using @Generics@-derivable helpers.

    This package differs from <http://hackage.haskell.org/package/gdiff gdiff>,
    in a two ways: @tree-diff@ doesn'\''t have patch function,
    and the "edit-script" is a tree itself, which is useful for pretty-printing.

    @
    >>> prettyEditExpr $ ediff (Foo 42 [True, False] "old") (Foo 42 [False, False, True] "new")
    Foo
    \  {fooBool = [-True, +False, False, +True],
    \   fooInt = 42,
    \   fooString = -"old" +"new"}
    @

category:             Data, Testing
abi:                  b40b8818a21cf6e24354be0a8e865616
exposed:              True
exposed-modules:
    Data.TreeDiff Data.TreeDiff.Class Data.TreeDiff.Expr
    Data.TreeDiff.Golden Data.TreeDiff.List Data.TreeDiff.OMap
    Data.TreeDiff.Parser Data.TreeDiff.Pretty Data.TreeDiff.QuickCheck
    Data.TreeDiff.Tree

import-dirs:          /usr/lib/ghc-9.4.8/site-local/tree-diff-0.3.0.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/tree-diff-0.3.0.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/tree-diff-0.3.0.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-tree-diff
hs-libraries:         HStree-diff-0.3.0.1-GNA3R5DCVKhFnGhPCw0Vd3
depends:
    QuickCheck-2.14.3-3S3WOBL6rHa3L0CMYI1WVh
    aeson-2.1.2.1-LDc25PpdH5WHlLB8Mcp2Rh
    ansi-terminal-1.0.2-9C7TLPMqFC3EnANnfcyKas
    ansi-wl-pprint-1.0.2-KP9Bn1AfSrMGWMTZm5pJQp base-4.17.2.1
    base-compat-0.12.3-H9qTMlLoDHsHlMi1O3x7Rp bytestring-0.11.5.3
    containers-0.6.7 deepseq-1.4.8.0
    hashable-1.4.4.0-85lkkmOSRZHDIzkr9EkKNp parsec-3.1.16.1
    parsers-0.12.12-5eBAUS44oB72eQOCpZb1Sj pretty-1.1.3.6
    primitive-0.9.1.0-KawCla5BA6F2MLtBZRS1Dh
    scientific-0.3.8.0-HUqAf4XaF5T5GawpMI5GwR
    semialign-1.3.1-FVqR6SRwIoW8AnsbydvKWV
    strict-0.5-3YqyrbNmr9gBQeoCoaFr88
    tagged-0.8.9-KMS3sfDasKWItFZcxfaN6C text-2.0.2
    these-1.2.1-FsoNf3khtpBE0WQeyNf7Ak time-1.12.2
    unordered-containers-0.2.20-Cw2Ec4BgC4sInKE4e5RLSk
    uuid-types-1.0.6-9HT5d1aFDJVGckTkPRv4GI
    vector-0.13.2.0-3jopdCx3MMLHVSrvHoDH9i

haddock-interfaces:   /usr/share/doc/haskell-tree-diff/html/tree-diff.haddock
haddock-html:         /usr/share/doc/haskell-tree-diff/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

