#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 tree-diff
version:              0.3.0.1
visibility:           public
id:                   tree-diff-0.3.0.1-KEiDiqTWKlY8TM6UhoxNq4
key:                  tree-diff-0.3.0.1-KEiDiqTWKlY8TM6UhoxNq4
license:              GPL-2.0-or-later
copyright:            (c) 2017-2021 Oleg Grenrus
maintainer:           Oleg.Grenrus <oleg.grenrus@iki.fi>
author:               Oleg Grenrus <oleg.grenrus@iki.fi>
homepage:             https://github.com/phadej/tree-diff
synopsis:             Diffing of (expression) trees.
description:
    Common diff algorithm works on list structures:

    @
    diff :: Eq a => [a] -> [a] -> [Edit a]
    @

    This package works on trees.

    @
    treeDiff :: Eq a => Tree a -> Tree a -> Edit (EditTree a)
    @

    This package also provides a way to diff arbitrary ADTs,
    using @Generics@-derivable helpers.

    This package differs from <http://hackage.haskell.org/package/gdiff gdiff>,
    in a two ways: @tree-diff@ doesn'\''t have patch function,
    and the "edit-script" is a tree itself, which is useful for pretty-printing.

    @
    >>> prettyEditExpr $ ediff (Foo 42 [True, False] "old") (Foo 42 [False, False, True] "new")
    Foo
    \  {fooBool = [-True, +False, False, +True],
    \   fooInt = 42,
    \   fooString = -"old" +"new"}
    @

category:             Data, Testing
abi:                  23ab4499a81d6641c9ab7822aaa3ae2c
exposed:              True
exposed-modules:
    Data.TreeDiff Data.TreeDiff.Class Data.TreeDiff.Expr
    Data.TreeDiff.Golden Data.TreeDiff.List Data.TreeDiff.OMap
    Data.TreeDiff.Parser Data.TreeDiff.Pretty Data.TreeDiff.QuickCheck
    Data.TreeDiff.Tree

import-dirs:          /usr/lib/ghc-9.4.8/site-local/tree-diff-0.3.0.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/tree-diff-0.3.0.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/tree-diff-0.3.0.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-tree-diff
hs-libraries:         HStree-diff-0.3.0.1-KEiDiqTWKlY8TM6UhoxNq4
depends:
    QuickCheck-2.14.3-2QKb6Hom0yuuAm9FvZ6nN
    aeson-2.1.2.1-2ooOAwlErgbHj6Tyvuh2I5
    ansi-terminal-1.0.2-6ZbytJewXtEJSCVeiG0zJh
    ansi-wl-pprint-1.0.2-G72M2lobxi75vRSUiZDKoo base-4.17.2.1
    base-compat-0.12.3-H9qTMlLoDHsHlMi1O3x7Rp bytestring-0.11.5.3
    containers-0.6.7 deepseq-1.4.8.0
    hashable-1.4.4.0-CTf4tWLvOCwE4B8hp3PoEK parsec-3.1.16.1
    parsers-0.12.12-GlcXgK72POlBWcSo2X9bth pretty-1.1.3.6
    primitive-0.9.1.0-3L6fSIJx0fWJUtVHVLpgAb
    scientific-0.3.7.0-Kb5Gqy0LO2R6GqxRC9SGn9
    semialign-1.3-L5Qe2yM1P2R74BCvx8dF6b
    strict-0.5-GIVbxC0qnBM4FlQvEZkT0w
    tagged-0.8.9-KMS3sfDasKWItFZcxfaN6C text-2.0.2
    these-1.2.1-KkupqsXLtAWAbRN3ifpX2j time-1.12.2
    unordered-containers-0.2.20-5aRSzj1YCHv4h2N6lFa6Hx
    uuid-types-1.0.6-7TS0mgNSpe6DCHBsUvRL2z
    vector-0.13.2.0-BWMo7dqC00725tIPRLs4rJ

haddock-interfaces:   /usr/share/doc/haskell-tree-diff/html/tree-diff.haddock
haddock-html:         /usr/share/doc/haskell-tree-diff/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

