#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 tomland
version:              1.3.3.3
visibility:           public
id:                   tomland-1.3.3.3-G9bAxTF3ENV4S02h40Aq2V
key:                  tomland-1.3.3.3-G9bAxTF3ENV4S02h40Aq2V
license:              MPL-2.0
copyright:            2018-2023 Kowainik
maintainer:           Kowainik <xrom.xkov@gmail.com>
author:               Dmitrii Kovanikov, Veronika Romashkina
homepage:             https://github.com/kowainik/tomland
synopsis:             Bidirectional TOML serialization
description:
    Implementation of bidirectional TOML serialization. Simple codecs look like this:

    @
    __data__ User = User
    \    { userName :: Text
    \    , userAge  :: Int
    \    }
    \
    \userCodec :: TomlCodec User
    \userCodec = User
    \    \<$\> Toml.text "name" .= userName
    \    \<*\> Toml.int  "age"  .= userAge
    @

    The following blog post has more details about library design:

    * [tomland: Bidirectional TOML serialization](https://kowainik.github.io/posts/2019-01-14-tomland)

category:             TOML, Text, Configuration
abi:                  6483d43d3d78264d614c251ffe2e17e6
exposed:              True
exposed-modules:
    Toml Toml.Codec Toml.Codec.BiMap Toml.Codec.BiMap.Conversion
    Toml.Codec.Code Toml.Codec.Combinator Toml.Codec.Combinator.Common
    Toml.Codec.Combinator.Custom Toml.Codec.Combinator.List
    Toml.Codec.Combinator.Map Toml.Codec.Combinator.Monoid
    Toml.Codec.Combinator.Primitive Toml.Codec.Combinator.Set
    Toml.Codec.Combinator.Table Toml.Codec.Combinator.Time
    Toml.Codec.Combinator.Tuple Toml.Codec.Di Toml.Codec.Error
    Toml.Codec.Generic Toml.Codec.Types Toml.Parser Toml.Parser.Core
    Toml.Parser.Item Toml.Parser.Key Toml.Parser.String
    Toml.Parser.Validate Toml.Parser.Value Toml.Type Toml.Type.AnyValue
    Toml.Type.Edsl Toml.Type.Key Toml.Type.PrefixTree Toml.Type.Printer
    Toml.Type.TOML Toml.Type.UValue Toml.Type.Value

import-dirs:          /usr/lib/ghc-9.4.8/site-local/tomland-1.3.3.3
library-dirs:         /usr/lib/ghc-9.4.8/site-local/tomland-1.3.3.3
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/tomland-1.3.3.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-tomland
hs-libraries:         HStomland-1.3.3.3-G9bAxTF3ENV4S02h40Aq2V
depends:
    base-4.17.2.1 bytestring-0.11.5.3 containers-0.6.7 deepseq-1.4.8.0
    hashable-1.4.4.0-JPfSbBrFTKBgQKoWbpACz
    megaparsec-9.6.1-5wqMRZqTk6B8Hn3YAbESf9 mtl-2.2.2
    parser-combinators-1.3.0-11YwG5dPNej79xqbn9HKav text-2.0.2
    time-1.12.2 unordered-containers-0.2.20-DaOkK38PYRa9pF7ZwbG4ZB
    validation-selective-0.2.0.0-DJV5jX0wIMT6nIrgwht2kl

haddock-interfaces:   /usr/share/doc/haskell-tomland/html/tomland.haddock
haddock-html:         /usr/share/doc/haskell-tomland/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

