#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 tidal
version:              1.9.5
visibility:           public
id:                   tidal-1.9.5-AqkCRJKs3vBBko0LrIpoZs
key:                  tidal-1.9.5-AqkCRJKs3vBBko0LrIpoZs
license:              GPL-3.0-only
copyright:            (c) Alex McLean and other contributors, 2021
maintainer:
    Alex McLean <alex@slab.org>, Mike Hodnick <mike.hodnick@gmail.com>

author:               Alex McLean
stability:            Experimental
homepage:             http://tidalcycles.org/
synopsis:             Pattern language for improvised music
description:
    Tidal is a domain specific language for live coding patterns.

category:             Sound
abi:                  d873d39f8d2e056b3c0ed924b87395c6
exposed:              True
exposed-modules:
    Paths_tidal Sound.Tidal.Bjorklund Sound.Tidal.Chords
    Sound.Tidal.Config Sound.Tidal.Context Sound.Tidal.Control
    Sound.Tidal.Core Sound.Tidal.ID Sound.Tidal.Params
    Sound.Tidal.ParseBP Sound.Tidal.Pattern Sound.Tidal.Safe.Boot
    Sound.Tidal.Safe.Context Sound.Tidal.Scales Sound.Tidal.Show
    Sound.Tidal.Simple Sound.Tidal.Stream Sound.Tidal.StreamTypes
    Sound.Tidal.Tempo Sound.Tidal.Time Sound.Tidal.Transition
    Sound.Tidal.UI Sound.Tidal.Utils Sound.Tidal.Version

import-dirs:          /usr/lib/ghc-9.4.8/site-local/tidal-1.9.5
library-dirs:         /usr/lib/ghc-9.4.8/site-local/tidal-1.9.5
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/tidal-1.9.5
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-tidal
hs-libraries:         HStidal-1.9.5-AqkCRJKs3vBBko0LrIpoZs
depends:
    base-4.17.2.1 bytestring-0.11.5.3
    clock-0.8.4-3mSKaHu3CxC9NkAJ0MDeyp
    colour-2.3.6-BOQojf8h30eLFkJd1jwXZl containers-0.6.7
    deepseq-1.4.8.0 exceptions-0.10.5 hosc-0.20-DSeqzUoRxgdLQWjTYfGVva
    mtl-2.2.2 network-3.1.4.0-KCu1LDB4kGQHeeCsiSLoOZ parsec-3.1.16.1
    primitive-0.9.1.0-6nUciex1vJZHfhyE758nym
    random-1.2.1.3-H7b6I1swtfqDNx62GlcOH8 text-2.0.2
    tidal-link-1.0.3-7Mc151D6ChFKmfvh1uyZiX transformers-0.5.6.2

haddock-interfaces:   /usr/share/doc/haskell-tidal/html/tidal.haddock
haddock-html:         /usr/share/doc/haskell-tidal/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

