#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 tidal
version:              1.9.5
visibility:           public
id:                   tidal-1.9.5-BJPAPLb5Yc36b5G9lifzc7
key:                  tidal-1.9.5-BJPAPLb5Yc36b5G9lifzc7
license:              GPL-3.0-only
copyright:            (c) Alex McLean and other contributors, 2021
maintainer:
    Alex McLean <alex@slab.org>, Mike Hodnick <mike.hodnick@gmail.com>

author:               Alex McLean
stability:            Experimental
homepage:             http://tidalcycles.org/
synopsis:             Pattern language for improvised music
description:
    Tidal is a domain specific language for live coding patterns.

category:             Sound
abi:                  1f848abaff60d251aa25b5760f2fa3c0
exposed:              True
exposed-modules:
    Paths_tidal Sound.Tidal.Bjorklund Sound.Tidal.Chords
    Sound.Tidal.Config Sound.Tidal.Context Sound.Tidal.Control
    Sound.Tidal.Core Sound.Tidal.ID Sound.Tidal.Params
    Sound.Tidal.ParseBP Sound.Tidal.Pattern Sound.Tidal.Safe.Boot
    Sound.Tidal.Safe.Context Sound.Tidal.Scales Sound.Tidal.Show
    Sound.Tidal.Simple Sound.Tidal.Stream Sound.Tidal.StreamTypes
    Sound.Tidal.Tempo Sound.Tidal.Time Sound.Tidal.Transition
    Sound.Tidal.UI Sound.Tidal.Utils Sound.Tidal.Version

import-dirs:          /usr/lib/ghc-9.4.8/site-local/tidal-1.9.5
library-dirs:         /usr/lib/ghc-9.4.8/site-local/tidal-1.9.5
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/tidal-1.9.5
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-tidal
hs-libraries:         HStidal-1.9.5-BJPAPLb5Yc36b5G9lifzc7
depends:
    base-4.17.2.1 bytestring-0.11.5.3
    clock-0.8.4-L4ShJDmmRGZGHiGqJ0vJRb
    colour-2.3.6-14wXRZZVmzHBy2nkCvSgrD containers-0.6.7
    deepseq-1.4.8.0 exceptions-0.10.5 hosc-0.20-E310qvGPhTuBEI4fdvsA2i
    mtl-2.2.2 network-3.1.4.0-L93bqt4J89t6uDPHvRPUpA parsec-3.1.16.1
    primitive-0.9.0.0-BHqivtPzLOB6VfmzYm3KVP
    random-1.2.1.3-6Q31h3pRIgvDA2QDH6tJjk text-2.0.2
    tidal-link-1.0.3-7Mc151D6ChFKmfvh1uyZiX transformers-0.5.6.2

haddock-interfaces:   /usr/share/doc/haskell-tidal/html/tidal.haddock
haddock-html:         /usr/share/doc/haskell-tidal/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

