#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 threads
version:              0.5.1.8
visibility:           public
id:                   threads-0.5.1.8-L46BOtW2ecGFZNMtvQo9YK
key:                  threads-0.5.1.8-L46BOtW2ecGFZNMtvQo9YK
license:              BSD-3-Clause
copyright:            2010–2012 Bas van Dijk & Roel van Dijk
maintainer:
    Bas van Dijk <v.dijk.bas@gmail.com>
    Roel van Dijk <vandijk.roel@gmail.com>

author:
    Bas van Dijk <v.dijk.bas@gmail.com>
    Roel van Dijk <vandijk.roel@gmail.com>

stability:            experimental
homepage:             https://github.com/basvandijk/threads
synopsis:             Fork threads and wait for their result
description:
    This package provides functions to fork threads and
    wait for their result, whether it'\''s an exception or a
    normal value.

    Besides waiting for the termination of a single thread
    this packages also provides functions to wait for a
    group of threads to terminate.

    This package is similar to the
    @threadmanager@, @async@ and @spawn@ packages.
    The advantages of this package are:

    * Simpler API.

    * More efficient in both space and time.

    * No space-leak when forking a large number of threads.

    * Correct handling of asynchronous exceptions.

    * GHC specific functionality like @forkOn@ and @forkIOWithUnmask@.

category:             Concurrency
abi:                  c42c0c6f493b76aa5081df81a7e9bd4e
exposed:              True
exposed-modules:
    Control.Concurrent.Thread Control.Concurrent.Thread.Group

hidden-modules:       Control.Concurrent.Raw
import-dirs:          /usr/lib/ghc-9.4.8/site-local/threads-0.5.1.8
library-dirs:         /usr/lib/ghc-9.4.8/site-local/threads-0.5.1.8
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/threads-0.5.1.8
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-threads
hs-libraries:         HSthreads-0.5.1.8-L46BOtW2ecGFZNMtvQo9YK
depends:              base-4.17.2.1 stm-2.5.1.0
haddock-interfaces:   /usr/share/doc/haskell-threads/html/threads.haddock
haddock-html:         /usr/share/doc/haskell-threads/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

