#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 th-desugar
version:              1.15
visibility:           public
id:                   th-desugar-1.15-BcPIDYJAYLgD3pveOziKL5
key:                  th-desugar-1.15-BcPIDYJAYLgD3pveOziKL5
license:              BSD-3-Clause
maintainer:           Ryan Scott <ryan.gl.scott@gmail.com>
author:               Richard Eisenberg <rae@cs.brynmawr.edu>
stability:            experimental
homepage:             https://github.com/goldfirere/th-desugar
synopsis:             Functions to desugar Template Haskell
description:
    This package provides the Language.Haskell.TH.Desugar module, which desugars
    Template Haskell'\''s rich encoding of Haskell syntax into a simpler encoding.
    This desugaring discards surface syntax information (such as the use of infix
    operators) but retains the original meaning of the TH code. The intended use
    of this package is as a preprocessor for more advanced code manipulation
    tools. Note that the input to any of the ds... functions should be produced
    from a TH quote, using the syntax [| ... |]. If the input to these functions
    is a hand-coded TH syntax tree, the results may be unpredictable. In
    particular, it is likely that promoted datatypes will not work as expected.

category:             Template Haskell
abi:                  f6015f58443236ad0d1bc984759fc5ad
exposed:              True
exposed-modules:
    Language.Haskell.TH.Desugar Language.Haskell.TH.Desugar.Expand
    Language.Haskell.TH.Desugar.Lift Language.Haskell.TH.Desugar.OMap
    Language.Haskell.TH.Desugar.OMap.Strict
    Language.Haskell.TH.Desugar.OSet Language.Haskell.TH.Desugar.Subst
    Language.Haskell.TH.Desugar.Sweeten

hidden-modules:
    Language.Haskell.TH.Desugar.AST Language.Haskell.TH.Desugar.Core
    Language.Haskell.TH.Desugar.FV Language.Haskell.TH.Desugar.Match
    Language.Haskell.TH.Desugar.Reify Language.Haskell.TH.Desugar.Util

import-dirs:          /usr/lib/ghc-9.4.8/site-local/th-desugar-1.15
library-dirs:         /usr/lib/ghc-9.4.8/site-local/th-desugar-1.15
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/th-desugar-1.15
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-th-desugar
hs-libraries:         HSth-desugar-1.15-BcPIDYJAYLgD3pveOziKL5
depends:
    base-4.17.2.1 containers-0.6.7 ghc-prim-0.9.1 mtl-2.2.2
    ordered-containers-0.2.4-Bhu1wYjg8ek9aWhrgdTaQT
    syb-0.7.2.4-4qGf5rQc5mM7uGogVkfZr0 template-haskell-2.19.0.0
    th-abstraction-0.5.0.0-BROQwjXmGCt8uLmQUfLqOy
    th-orphans-0.13.16-9gLlkrtr8KBk1idA5joBh
    transformers-compat-0.7.2-F1TSDgHxVH372cWL2D3XnQ

haddock-interfaces:   /usr/share/doc/haskell-th-desugar/html/th-desugar.haddock
haddock-html:         /usr/share/doc/haskell-th-desugar/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

