#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 text-short
version:              0.1.6
visibility:           public
id:                   text-short-0.1.6-JuParaFlytB3yHsA4QF9zw
key:                  text-short-0.1.6-JuParaFlytB3yHsA4QF9zw
license:              BSD-3-Clause
maintainer:           hvr@gnu.org
author:               Herbert Valerio Riedel
synopsis:             Memory-efficient representation of Unicode text strings
description:
    This package provides the '\''ShortText'\'' type which is suitable for keeping many short strings in memory. This is similiar to how '\''ShortByteString'\'' relates to '\''ByteString'\''.

    The main difference between '\''Text'\'' and '\''ShortText'\'' is that '\''ShortText'\'' doesn'\''t support zero-copy slicing (thereby saving 2 words), and, compared to text-1.*, that it uses UTF-8 instead of UTF-16 internally. Consequently, the memory footprint of a (boxed) '\''ShortText'\'' value is 4 words (2 words when unboxed) plus the length of the UTF-8 encoded payload.

category:             Data
abi:                  5116bb1d145c09eab83cbb501741ffa9
exposed:              True
exposed-modules:
    Data.Text.Short Data.Text.Short.Partial Data.Text.Short.Unsafe

hidden-modules:       Data.Text.Short.Internal PrimOps
import-dirs:          /usr/lib/ghc-9.4.8/site-local/text-short-0.1.6
library-dirs:         /usr/lib/ghc-9.4.8/site-local/text-short-0.1.6
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/text-short-0.1.6
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-text-short
hs-libraries:         HStext-short-0.1.6-JuParaFlytB3yHsA4QF9zw
depends:
    base-4.17.2.1 binary-0.8.9.1 bytestring-0.11.5.3 deepseq-1.4.8.0
    ghc-prim-0.9.1 hashable-1.4.4.0-CTf4tWLvOCwE4B8hp3PoEK
    template-haskell-2.19.0.0 text-2.0.2

haddock-interfaces:   /usr/share/doc/haskell-text-short/html/text-short.haddock
haddock-html:         /usr/share/doc/haskell-text-short/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

